/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jdbc.docker.compose;

import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;
import org.springframework.boot.jdbc.autoconfigure.JdbcConnectionDetails;
import org.springframework.boot.jdbc.docker.compose.JdbcUrlBuilder;
import org.springframework.boot.jdbc.docker.compose.MySqlEnvironment;

class MySqlJdbcDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<JdbcConnectionDetails> {
    protected MySqlJdbcDockerComposeConnectionDetailsFactory() {
        super("mysql", new String[0]);
    }

    protected JdbcConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new MySqlJdbcDockerComposeConnectionDetails(source.getRunningService());
    }

    static class MySqlJdbcDockerComposeConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements JdbcConnectionDetails {
        private static final JdbcUrlBuilder jdbcUrlBuilder = new JdbcUrlBuilder("mysql", 3306);
        private final MySqlEnvironment environment;
        private final String jdbcUrl;

        MySqlJdbcDockerComposeConnectionDetails(RunningService service) {
            super(service);
            this.environment = new MySqlEnvironment(service.env());
            this.jdbcUrl = jdbcUrlBuilder.build(service, this.environment.getDatabase());
        }

        @Override
        public String getUsername() {
            return this.environment.getUsername();
        }

        @Override
        public String getPassword() {
            return this.environment.getPassword();
        }

        @Override
        public String getJdbcUrl() {
            return this.jdbcUrl;
        }
    }
}

