/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.canbridge.trace;

import com.revrobotics.canbridge.CanMessage;
import com.revrobotics.canbridge.trace.CanTracer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;

public class PCANTracer
implements CanTracer {
    private final File file;
    private final Writer writer;
    private static final LocalDate epochDate = LocalDate.of(1899, 12, 30);
    private static final long MILLIS_PER_DAY = 86400000L;
    private final AtomicInteger messageCount = new AtomicInteger(0);
    private final long startTimeNano = System.nanoTime();
    private static final String fileHeaderTemplate = ";$FILEVERSION=2.0\n;$STARTTIME={now}\n;$COLUMNS=N,O,T,I,d,l,D\n;\n; {filepath}\n; Start time: {day}.{month}.{year} {time}\n; Generated by REV UI\n;-------------------------------------------------------------------------------\n; Connection    Bit rate\n; REV CAN Bridge Nominal 1 MBit/s\n;-------------------------------------------------------------------------------\n; Message Time    Type   ID     Rx/Tx\n; Number  Offset  |      [hex]  |   Data Length\n; |       [ms]    |      |      |   |   Data [hex] ...\n; |       |       |      |      |   |   |\n;-+---- --+-----  +-   --+----- +-  +-  +- -- -- -- -- -- -- --\n";

    public PCANTracer(String fileName) {
        this(new File(fileName));
    }

    PCANTracer(File file) {
        this.file = file;
        try {
            file.createNewFile();
            this.writer = new BufferedWriter(new FileWriter(file));
            this.writeHeader();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                this.writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }));
    }

    @Override
    public void onCanMessageSentByDesktop(CanMessage message) {
        this.writeMessage(message, false);
    }

    @Override
    public void onCanMessageReceivedByDesktop(CanMessage message) {
        this.writeMessage(message, true);
    }

    private double getTimeOffset() {
        return (double)(System.nanoTime() - this.startTimeNano) / 1000000.0;
    }

    private void writeMessage(CanMessage message, boolean rx) {
        int messageNumber = this.messageCount.getAndIncrement();
        double timeOffset = this.getTimeOffset();
        String line = String.format("%7d %8.3f  %s   %08x %s  %2d  %s", messageNumber, timeOffset, message.isRtr() ? "RR" : "DT", message.messageId(), rx ? "Rx" : "Tx", message.data().length, this.dataString(message.data()));
        try {
            this.writer.write(line + "\n");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String createFileHeader(String filepath) {
        LocalDateTime now = LocalDateTime.now();
        return fileHeaderTemplate.replace("{now}", PCANTracer.getStartTimeString()).replace("{year}", String.valueOf(now.getYear())).replace("{month}", String.format("%02d", now.getMonthValue())).replace("{day}", String.format("%02d", now.getDayOfMonth())).replace("{time}", String.format("%02d:%02d:%02d.%09d", now.getHour(), now.getMinute(), now.getSecond(), now.getNano())).replace("{filepath}", filepath);
    }

    private static String getStartTimeString() {
        LocalDateTime now = LocalDateTime.now();
        long days = ChronoUnit.DAYS.between(epochDate, now.toLocalDate());
        LocalTime t = now.toLocalTime();
        long millisOfDay = (long)t.toSecondOfDay() * 1000L + (long)t.getNano() / 1000000L;
        double fraction = (double)millisOfDay / 8.64E7;
        String fracStr = String.format(Locale.ROOT, "%.09f", fraction).substring(2);
        return days + "." + fracStr;
    }

    private void writeHeader() {
        try {
            this.writer.write(PCANTracer.createFileHeader(this.file.getAbsolutePath()));
        }
        catch (IOException e) {
            System.out.println("Failed to write header to file " + this.file.getAbsolutePath());
        }
    }

    private String dataString(byte[] data) {
        StringBuilder sb = new StringBuilder();
        for (byte b : data) {
            sb.append(String.format("%02x ", b));
        }
        return sb.toString();
    }
}

