/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint.web;

import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.actuate.endpoint.EndpointId;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@FunctionalInterface
public interface PathMapper {
    public @Nullable String getRootPath(EndpointId var1);

    public static String getRootPath(@Nullable List<PathMapper> pathMappers, EndpointId endpointId) {
        Assert.notNull((Object)endpointId, (String)"'endpointId' must not be null");
        if (pathMappers != null) {
            for (PathMapper mapper : pathMappers) {
                String path = mapper.getRootPath(endpointId);
                if (!StringUtils.hasText((String)path)) continue;
                return path;
            }
        }
        return endpointId.toString();
    }
}

