/*
 * Decompiled with CFR 0.152.
 */
package io.github.wimdeblauwe.htmx.spring.boot.security;

import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxLocation;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxRequestHeader;
import io.github.wimdeblauwe.htmx.spring.boot.security.HxLocationRedirectStrategy;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Map;
import org.springframework.http.HttpStatus;
import tools.jackson.databind.json.JsonMapper;

public class HxLocationBoostedRedirectStrategy
extends HxLocationRedirectStrategy {
    private final JsonMapper jsonMapper = new JsonMapper();

    public HxLocationBoostedRedirectStrategy() {
        this(HttpStatus.OK);
    }

    public HxLocationBoostedRedirectStrategy(HttpStatus status) {
        super(status);
    }

    @Override
    protected void sendHxLocationRedirect(HttpServletRequest request, HttpServletResponse response, String url) throws IOException {
        super.sendHxLocationRedirect(request, response, this.boosted(url));
    }

    protected String boosted(String url) {
        HtmxLocation location = new HtmxLocation(url);
        location.setTarget("body");
        location.setHeaders(Map.of(HtmxRequestHeader.HX_BOOSTED.getValue(), "true"));
        return this.jsonMapper.writeValueAsString((Object)location);
    }
}

