/*
 * Decompiled with CFR 0.152.
 */
package io.github.wimdeblauwe.htmx.spring.boot.security;

import io.github.wimdeblauwe.htmx.spring.boot.security.HxLocationRedirectStrategy;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;

public class HxLocationRedirectAuthenticationSuccessHandler
implements AuthenticationSuccessHandler {
    private final AuthenticationSuccessHandler delegate;

    public HxLocationRedirectAuthenticationSuccessHandler(String defaultSuccessUrl) {
        this(defaultSuccessUrl, false);
    }

    public HxLocationRedirectAuthenticationSuccessHandler(String defaultSuccessUrl, boolean alwaysUse) {
        this(defaultSuccessUrl, alwaysUse, new HxLocationRedirectStrategy());
    }

    public HxLocationRedirectAuthenticationSuccessHandler(String defaultSuccessUrl, RedirectStrategy redirectStrategy) {
        this(defaultSuccessUrl, false, redirectStrategy);
    }

    public HxLocationRedirectAuthenticationSuccessHandler(String defaultSuccessUrl, boolean alwaysUse, RedirectStrategy redirectStrategy) {
        SavedRequestAwareAuthenticationSuccessHandler handler = new SavedRequestAwareAuthenticationSuccessHandler();
        handler.setDefaultTargetUrl(defaultSuccessUrl);
        handler.setAlwaysUseDefaultTargetUrl(alwaysUse);
        handler.setRedirectStrategy(redirectStrategy);
        this.delegate = handler;
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        this.delegate.onAuthenticationSuccess(request, response, authentication);
    }
}

