/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core;

import org.jspecify.annotations.Nullable;

public abstract class NativeDetector {
    private static final @Nullable String imageCode = System.getProperty("org.graalvm.nativeimage.imagecode");
    private static final boolean inNativeImage = imageCode != null;

    public static boolean inNativeImage() {
        return inNativeImage;
    }

    public static boolean inNativeImage(Context ... contexts) {
        for (Context context : contexts) {
            if (!context.key.equals(imageCode)) continue;
            return true;
        }
        return false;
    }

    public static enum Context {
        BUILD("buildtime"),
        RUN("runtime");

        private final String key;

        private Context(String key) {
            this.key = key;
        }

        public String toString() {
            return this.key;
        }
    }
}

