/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.core.DecoratingProxy;
import org.springframework.core.OrderComparator;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.annotation.OrderUtils;

public class AnnotationAwareOrderComparator
extends OrderComparator {
    public static final AnnotationAwareOrderComparator INSTANCE = new AnnotationAwareOrderComparator();

    @Override
    protected @Nullable Integer findOrder(Object obj) {
        Integer order = super.findOrder(obj);
        if (order != null) {
            return order;
        }
        return this.findOrderFromAnnotation(obj);
    }

    private @Nullable Integer findOrderFromAnnotation(Object obj) {
        AnnotatedElement annotatedElement;
        if (obj instanceof AnnotatedElement) {
            AnnotatedElement ae = (AnnotatedElement)obj;
            annotatedElement = ae;
        } else {
            annotatedElement = obj.getClass();
        }
        Class<?> element = annotatedElement;
        MergedAnnotations annotations = MergedAnnotations.from(element, MergedAnnotations.SearchStrategy.TYPE_HIERARCHY);
        Integer order = OrderUtils.getOrderFromAnnotations(element, annotations);
        if (order == null && obj instanceof DecoratingProxy) {
            DecoratingProxy decoratingProxy = (DecoratingProxy)obj;
            return this.findOrderFromAnnotation(decoratingProxy.getDecoratedClass());
        }
        return order;
    }

    @Override
    public @Nullable Integer getPriority(Object obj) {
        if (obj instanceof Class) {
            Class clazz = (Class)obj;
            return OrderUtils.getPriority(clazz);
        }
        Integer priority = OrderUtils.getPriority(obj.getClass());
        if (priority == null && obj instanceof DecoratingProxy) {
            DecoratingProxy decoratingProxy = (DecoratingProxy)obj;
            return this.getPriority(decoratingProxy.getDecoratedClass());
        }
        return priority;
    }

    public static void sort(List<?> list) {
        if (list.size() > 1) {
            list.sort(INSTANCE);
        }
    }

    public static void sort(Object[] array) {
        if (array.length > 1) {
            Arrays.sort(array, INSTANCE);
        }
    }

    public static void sortIfNecessary(Object value) {
        if (value instanceof Object[]) {
            Object[] objects = (Object[])value;
            AnnotationAwareOrderComparator.sort(objects);
        } else if (value instanceof List) {
            List list = (List)value;
            AnnotationAwareOrderComparator.sort(list);
        }
    }
}

