/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.condition;

import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnThreading;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.thread.Threading;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.Assert;

class OnThreadingCondition
extends SpringBootCondition {
    OnThreadingCondition() {
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        @Nullable Map attributes = metadata.getAnnotationAttributes(ConditionalOnThreading.class.getName());
        Assert.state((attributes != null ? 1 : 0) != 0, (String)"'attributes' must not be null");
        Threading threading = (Threading)attributes.get("value");
        Assert.state((threading != null ? 1 : 0) != 0, (String)"'threading' must not be null");
        return this.getMatchOutcome(context.getEnvironment(), threading);
    }

    private ConditionOutcome getMatchOutcome(Environment environment, Threading threading) {
        String name = threading.name();
        ConditionMessage.Builder message = ConditionMessage.forCondition(ConditionalOnThreading.class, new Object[0]);
        if (threading.isActive(environment)) {
            return ConditionOutcome.match(message.foundExactly(name));
        }
        return ConditionOutcome.noMatch(message.didNotFind(name).atAll());
    }
}

