/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webmvc.api;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springdoc.api.OpenApiResourceNotFoundException;
import org.springdoc.core.customizers.SpringDocCustomizers;
import org.springdoc.core.models.GroupedOpenApi;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springdoc.core.providers.SpringDocProviders;
import org.springdoc.core.service.AbstractRequestService;
import org.springdoc.core.service.GenericResponseService;
import org.springdoc.core.service.OpenAPIService;
import org.springdoc.core.service.OperationService;
import org.springdoc.webmvc.api.OpenApiActuatorResource;
import org.springdoc.webmvc.api.OpenApiResource;
import org.springdoc.webmvc.api.OpenApiWebMvcResource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectFactory;

public abstract class MultipleOpenApiResource
implements InitializingBean {
    private final List<GroupedOpenApi> groupedOpenApis;
    private final ObjectFactory<OpenAPIService> defaultOpenAPIBuilder;
    private final AbstractRequestService requestBuilder;
    private final GenericResponseService responseBuilder;
    private final OperationService operationParser;
    private final SpringDocProviders springDocProviders;
    private final SpringDocConfigProperties springDocConfigProperties;
    private final SpringDocCustomizers springDocCustomizers;
    private Map<String, OpenApiResource> groupedOpenApiResources;

    protected MultipleOpenApiResource(List<GroupedOpenApi> groupedOpenApis, ObjectFactory<OpenAPIService> defaultOpenAPIBuilder, AbstractRequestService requestBuilder, GenericResponseService responseBuilder, OperationService operationParser, SpringDocConfigProperties springDocConfigProperties, SpringDocProviders springDocProviders, SpringDocCustomizers springDocCustomizers) {
        this.groupedOpenApis = groupedOpenApis;
        this.defaultOpenAPIBuilder = defaultOpenAPIBuilder;
        this.requestBuilder = requestBuilder;
        this.responseBuilder = responseBuilder;
        this.operationParser = operationParser;
        this.springDocConfigProperties = springDocConfigProperties;
        this.springDocProviders = springDocProviders;
        this.springDocCustomizers = springDocCustomizers;
    }

    public void afterPropertiesSet() {
        this.groupedOpenApis.forEach(groupedOpenApi -> {
            this.springDocCustomizers.getGlobalOpenApiCustomizers().ifPresent(arg_0 -> ((GroupedOpenApi)groupedOpenApi).addAllOpenApiCustomizer(arg_0));
            this.springDocCustomizers.getGlobalOperationCustomizers().ifPresent(arg_0 -> ((GroupedOpenApi)groupedOpenApi).addAllOperationCustomizer(arg_0));
            this.springDocCustomizers.getGlobalOpenApiMethodFilters().ifPresent(arg_0 -> ((GroupedOpenApi)groupedOpenApi).addAllOpenApiMethodFilter(arg_0));
        });
        this.groupedOpenApiResources = this.groupedOpenApis.stream().collect(Collectors.toMap(GroupedOpenApi::getGroup, item -> {
            SpringDocConfigProperties.GroupConfig groupConfig = new SpringDocConfigProperties.GroupConfig(item.getGroup(), item.getPathsToMatch(), item.getPackagesToScan(), item.getPackagesToExclude(), item.getPathsToExclude(), item.getProducesToMatch(), item.getConsumesToMatch(), item.getHeadersToMatch(), item.getDisplayName());
            this.springDocConfigProperties.addGroupConfig(groupConfig);
            return this.buildWebMvcOpenApiResource((GroupedOpenApi)item);
        }, (existingValue, newValue) -> existingValue));
    }

    private OpenApiResource buildWebMvcOpenApiResource(GroupedOpenApi item) {
        if (!this.springDocConfigProperties.isUseManagementPort() && !"x-actuator".equals(item.getGroup())) {
            return new OpenApiWebMvcResource(item.getGroup(), this.defaultOpenAPIBuilder, this.requestBuilder, this.responseBuilder, this.operationParser, this.springDocConfigProperties, this.springDocProviders, new SpringDocCustomizers(Optional.of(item.getOpenApiCustomizers()), Optional.of(item.getOperationCustomizers()), Optional.of(item.getRouterOperationCustomizers()), Optional.of(item.getOpenApiMethodFilters()), Optional.empty(), Optional.empty()));
        }
        return new OpenApiActuatorResource(item.getGroup(), this.defaultOpenAPIBuilder, this.requestBuilder, this.responseBuilder, this.operationParser, this.springDocConfigProperties, this.springDocProviders, new SpringDocCustomizers(Optional.of(item.getOpenApiCustomizers()), Optional.of(item.getOperationCustomizers()), Optional.of(item.getRouterOperationCustomizers()), Optional.of(item.getOpenApiMethodFilters()), Optional.empty(), Optional.empty()));
    }

    protected OpenApiResource getOpenApiResourceOrThrow(String group) {
        OpenApiResource openApiResource = this.groupedOpenApiResources.get(group);
        if (openApiResource == null) {
            throw new OpenApiResourceNotFoundException("No OpenAPI resource found for group: " + group);
        }
        return openApiResource;
    }
}

