/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics;

import com.revrobotics.CIEColor;
import edu.wpi.first.hal.SimDevice;
import edu.wpi.first.hal.SimDouble;
import edu.wpi.first.wpilibj.DriverStation;
import edu.wpi.first.wpilibj.I2C;
import edu.wpi.first.wpilibj.util.Color;

public class ColorSensorV3 {
    private static final byte kAddress = 82;
    private static final byte kPartID = -62;
    private I2C m_i2c;
    private SimDevice m_simDevice;
    private SimDouble m_simR;
    private SimDouble m_simG;
    private SimDouble m_simB;
    private SimDouble m_simIR;
    private SimDouble m_simProx;
    private final double[] Cmatrix = new double[]{0.048112847, 0.289453437, -0.084950826, -0.030754752, 0.339680186, -0.071569905, -0.093947499, 0.072838494, 0.34024948};

    public ColorSensorV3(I2C.Port port) {
        this.m_i2c = new I2C(port, 82);
        this.m_simDevice = SimDevice.create((String)"REV Color Sensor V3", (int)port.value, (int)82);
        if (this.m_simDevice != null) {
            this.m_simR = this.m_simDevice.createDouble("Red", SimDevice.Direction.kInput, 0.0);
            this.m_simG = this.m_simDevice.createDouble("Green", SimDevice.Direction.kInput, 0.0);
            this.m_simB = this.m_simDevice.createDouble("Blue", SimDevice.Direction.kInput, 0.0);
            this.m_simIR = this.m_simDevice.createDouble("IR", SimDevice.Direction.kInput, 0.0);
            this.m_simProx = this.m_simDevice.createDouble("Proximity", SimDevice.Direction.kInput, 0.0);
            return;
        }
        if (!this.checkDeviceID(this.m_simDevice == null)) {
            return;
        }
        this.initializeDevice();
        this.hasReset();
    }

    public void configureProximitySensorLED(LEDPulseFrequency freq, LEDCurrent curr, int pulses) {
        this.write8(Register.kProximitySensorLED, freq.bVal | curr.bVal);
        this.write8(Register.kProximitySensorPulses, (byte)pulses);
    }

    public void configureProximitySensor(ProximitySensorResolution res, ProximitySensorMeasurementRate rate) {
        this.write8(Register.kProximitySensorRate, res.bVal | rate.bVal);
    }

    public void configureColorSensor(ColorSensorResolution res, ColorSensorMeasurementRate rate, GainFactor gain) {
        this.write8(Register.kLightSensorMeasurementRate, res.bVal | rate.bVal);
        this.write8(Register.kLightSensorGain, gain.bVal);
    }

    public Color getColor() {
        double r = this.getRed();
        double g = this.getGreen();
        double b = this.getBlue();
        double mag = r + g + b;
        return new Color(r / mag, g / mag, b / mag);
    }

    public int getProximity() {
        if (this.m_simDevice != null) {
            return (int)this.m_simProx.get();
        }
        return this.read11BitRegister(Register.kProximityData);
    }

    public RawColor getRawColor() {
        return new RawColor(this.getRed(), this.getGreen(), this.getBlue(), this.getIR());
    }

    public int getRed() {
        if (this.m_simDevice != null) {
            return (int)this.m_simR.get();
        }
        return this.read20BitRegister(Register.kDataRed);
    }

    public int getGreen() {
        if (this.m_simDevice != null) {
            return (int)this.m_simG.get();
        }
        return this.read20BitRegister(Register.kDataGreen);
    }

    public int getBlue() {
        if (this.m_simDevice != null) {
            return (int)this.m_simB.get();
        }
        return this.read20BitRegister(Register.kDataBlue);
    }

    public int getIR() {
        if (this.m_simDevice != null) {
            return (int)this.m_simIR.get();
        }
        return this.read20BitRegister(Register.kDataInfrared);
    }

    public CIEColor getCIEColor() {
        RawColor raw = this.getRawColor();
        return new CIEColor(this.Cmatrix[0] * (double)raw.red + this.Cmatrix[1] * (double)raw.green + this.Cmatrix[2] * (double)raw.blue, this.Cmatrix[3] * (double)raw.red + this.Cmatrix[4] * (double)raw.green + this.Cmatrix[5] * (double)raw.blue, this.Cmatrix[6] * (double)raw.red + this.Cmatrix[7] * (double)raw.green + this.Cmatrix[8] * (double)raw.blue);
    }

    public boolean hasReset() {
        if (this.m_simDevice != null) {
            return false;
        }
        byte[] raw = new byte[1];
        this.m_i2c.read((int)Register.kMainStatus.bVal, 1, raw);
        return (raw[0] & 0x20) != 0;
    }

    public boolean isConnected() {
        if (this.m_simDevice != null) {
            return true;
        }
        return this.checkDeviceID(false);
    }

    private boolean checkDeviceID(boolean reportErrors) {
        byte[] raw = new byte[1];
        if (this.m_i2c.read((int)Register.kPartID.bVal, 1, raw)) {
            if (reportErrors) {
                DriverStation.reportError((String)"Could not find REV color sensor", (boolean)false);
            }
            return false;
        }
        if (-62 != raw[0]) {
            if (reportErrors) {
                DriverStation.reportError((String)"Unknown device found with same I2C address as REV color sensor", (boolean)false);
            }
            return false;
        }
        return true;
    }

    private void initializeDevice() {
        this.write8(Register.kMainCtrl, MainControl.kRGBMode.bVal | MainControl.kLightSensorEnable.bVal | MainControl.kProximitySensorEnable.bVal);
        this.write8(Register.kProximitySensorRate, ProximitySensorResolution.kProxRes11bit.bVal | ProximitySensorMeasurementRate.kProxRate100ms.bVal);
        this.write8(Register.kProximitySensorPulses, 32);
    }

    private int read11BitRegister(Register reg) {
        byte[] raw = new byte[2];
        this.m_i2c.read((int)reg.bVal, 2, raw);
        return (raw[0] & 0xFF | (raw[1] & 0xFF) << 8) & 0x7FF;
    }

    private int read20BitRegister(Register reg) {
        byte[] raw = new byte[3];
        this.m_i2c.read((int)reg.bVal, 3, raw);
        return (raw[0] & 0xFF | (raw[1] & 0xFF) << 8 | (raw[2] & 0xFF) << 16) & 0x3FFFF;
    }

    private void write8(Register reg, int data) {
        this.m_i2c.write((int)reg.bVal, data);
    }

    public static enum Register {
        kMainCtrl(0),
        kProximitySensorLED(1),
        kProximitySensorPulses(2),
        kProximitySensorRate(3),
        kLightSensorMeasurementRate(4),
        kLightSensorGain(5),
        kPartID(6),
        kMainStatus(7),
        kProximityData(8),
        kDataInfrared(10),
        kDataGreen(13),
        kDataBlue(16),
        kDataRed(19);

        public final byte bVal;

        private Register(int i) {
            this.bVal = (byte)i;
        }
    }

    public static enum LEDPulseFrequency {
        kFreq60kHz(24),
        kFreq70kHz(64),
        kFreq80kHz(40),
        kFreq90kHz(48),
        kFreq100kHz(56);

        public final byte bVal;

        private LEDPulseFrequency(int i) {
            this.bVal = (byte)i;
        }
    }

    public static enum LEDCurrent {
        kPulse2mA(0),
        kPulse5mA(1),
        kPulse10mA(2),
        kPulse25mA(3),
        kPulse50mA(4),
        kPulse75mA(5),
        kPulse100mA(6),
        kPulse125mA(7);

        public final byte bVal;

        private LEDCurrent(int i) {
            this.bVal = (byte)i;
        }
    }

    public static enum ProximitySensorResolution {
        kProxRes8bit(0),
        kProxRes9bit(8),
        kProxRes10bit(16),
        kProxRes11bit(24);

        public final byte bVal;

        private ProximitySensorResolution(int i) {
            this.bVal = (byte)i;
        }
    }

    public static enum ProximitySensorMeasurementRate {
        kProxRate6ms(1),
        kProxRate12ms(2),
        kProxRate25ms(3),
        kProxRate50ms(4),
        kProxRate100ms(5),
        kProxRate200ms(6),
        kProxRate400ms(7);

        public final byte bVal;

        private ProximitySensorMeasurementRate(int i) {
            this.bVal = (byte)i;
        }
    }

    public static enum ColorSensorResolution {
        kColorSensorRes20bit(0),
        kColorSensorRes19bit(16),
        kColorSensorRes18bit(32),
        kColorSensorRes17bit(48),
        kColorSensorRes16bit(64),
        kColorSensorRes13bit(80);

        public final byte bVal;

        private ColorSensorResolution(int i) {
            this.bVal = (byte)i;
        }
    }

    public static enum ColorSensorMeasurementRate {
        kColorRate25ms(0),
        kColorRate50ms(1),
        kColorRate100ms(2),
        kColorRate200ms(3),
        kColorRate500ms(4),
        kColorRate1000ms(5),
        kColorRate2000ms(7);

        public final byte bVal;

        private ColorSensorMeasurementRate(int i) {
            this.bVal = (byte)i;
        }
    }

    public static enum GainFactor {
        kGain1x(0),
        kGain3x(1),
        kGain6x(2),
        kGain9x(3),
        kGain18x(4);

        public final byte bVal;

        private GainFactor(int i) {
            this.bVal = (byte)i;
        }
    }

    public static class RawColor {
        public int red;
        public int green;
        public int blue;
        public int ir;

        public RawColor(int r, int g, int b, int _ir) {
            this.red = r;
            this.green = g;
            this.blue = b;
            this.ir = _ir;
        }
    }

    public static enum MainControl {
        kRGBMode(4),
        kLightSensorEnable(2),
        kProximitySensorEnable(1),
        OFF(0);

        public final byte bVal;

        private MainControl(int i) {
            this.bVal = (byte)i;
        }
    }
}

