/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.spark;

import com.revrobotics.jni.CANSparkJNI;
import com.revrobotics.sim.MovingAverageFilterSim;
import com.revrobotics.sim.NoiseGenerator;
import com.revrobotics.sim.SparkAbsoluteEncoderSim;
import com.revrobotics.sim.SparkAnalogSensorSim;
import com.revrobotics.sim.SparkFlexExternalEncoderSim;
import com.revrobotics.sim.SparkFlexSim;
import com.revrobotics.sim.SparkLimitSwitchSim;
import com.revrobotics.sim.SparkMaxAlternateEncoderSim;
import com.revrobotics.sim.SparkMaxSim;
import com.revrobotics.sim.SparkRelativeEncoderSim;
import com.revrobotics.sim.SparkSimFaultManager;
import com.revrobotics.spark.ClosedLoopSlot;
import com.revrobotics.spark.FeedbackSensor;
import com.revrobotics.spark.SparkBase;
import com.revrobotics.spark.SparkFlex;
import com.revrobotics.spark.SparkLowLevel;
import com.revrobotics.spark.SparkMax;
import edu.wpi.first.hal.SimDouble;
import edu.wpi.first.hal.SimInt;
import edu.wpi.first.math.system.plant.DCMotor;
import edu.wpi.first.wpilibj.DriverStation;
import edu.wpi.first.wpilibj.simulation.SimDeviceSim;

public class SparkSim {
    private final SimDouble m_appliedOutput;
    private final SimDouble m_velocity;
    private final SimDouble m_position;
    private final SimDouble m_busVoltage;
    private final SimDouble m_motorCurrent;
    private final SimDouble m_setpoint;
    private final SimDouble m_arbFF;
    private final SimInt m_closedLoopSlot;
    private final SimInt m_arbFFUnits;
    private final SparkBase m_spark;
    private final DCMotor m_dcMotor;
    private final SimInt m_controlMode;
    private final MovingAverageFilterSim m_velocityAverage = new MovingAverageFilterSim(2, 0.016);
    private Boolean m_enable = null;
    private String m_deviceName;

    public SparkSim(SparkBase spark, DCMotor motor) {
        String deviceType = "UNKNOWN";
        if (spark.getSparkModel() == SparkLowLevel.SparkModel.SparkFlex) {
            deviceType = "SPARK Flex";
        } else if (spark.getSparkModel() == SparkLowLevel.SparkModel.SparkMax) {
            deviceType = "SPARK MAX";
        }
        this.m_deviceName = deviceType + " [" + spark.getDeviceId() + "]";
        SimDeviceSim sparkSim = new SimDeviceSim(this.m_deviceName);
        this.m_appliedOutput = sparkSim.getDouble("Applied Output");
        this.m_position = sparkSim.getDouble("Position");
        this.m_velocity = sparkSim.getDouble("Velocity");
        this.m_busVoltage = sparkSim.getDouble("Bus Voltage");
        this.m_motorCurrent = sparkSim.getDouble("Motor Current");
        this.m_setpoint = sparkSim.getDouble("Setpoint");
        this.m_arbFF = sparkSim.getDouble("Arbitrary Feedforward");
        this.m_closedLoopSlot = sparkSim.getInt("Closed Loop Slot");
        this.m_arbFFUnits = sparkSim.getInt("ArbFF Units");
        this.m_controlMode = sparkSim.getInt("Control Mode");
        this.m_spark = spark;
        this.m_dcMotor = motor;
    }

    public double getAppliedOutput() {
        return this.m_appliedOutput.get();
    }

    public void setAppliedOutput(double appliedOutput) {
        this.m_appliedOutput.set(appliedOutput);
    }

    public double getSetpoint() {
        return this.m_setpoint.get();
    }

    public ClosedLoopSlot getClosedLoopSlot() {
        switch (this.m_closedLoopSlot.get()) {
            case 0: {
                return ClosedLoopSlot.kSlot0;
            }
            case 1: {
                return ClosedLoopSlot.kSlot1;
            }
            case 2: {
                return ClosedLoopSlot.kSlot2;
            }
            case 3: {
                return ClosedLoopSlot.kSlot3;
            }
        }
        return ClosedLoopSlot.kSlot0;
    }

    private boolean runLimitLogic(boolean forward) {
        if (forward) {
            if (this.m_spark.getSparkModel() == SparkLowLevel.SparkModel.SparkFlex ? ((SparkFlex)this.m_spark).configAccessor.softLimit.getForwardSoftLimitEnabled() && ((SparkFlex)this.m_spark).configAccessor.softLimit.getForwardSoftLimit() < this.m_position.get() : this.m_spark.getSparkModel() == SparkLowLevel.SparkModel.SparkMax && ((SparkMax)this.m_spark).configAccessor.softLimit.getForwardSoftLimitEnabled() && ((SparkMax)this.m_spark).configAccessor.softLimit.getForwardSoftLimit() < this.m_position.get()) {
                return true;
            }
            return this.getForwardLimitSwitchSim().getEnabled() && this.getForwardLimitSwitchSim().getPressed();
        }
        if (this.m_spark.getSparkModel() == SparkLowLevel.SparkModel.SparkFlex ? ((SparkFlex)this.m_spark).configAccessor.softLimit.getReverseSoftLimitEnabled() && ((SparkFlex)this.m_spark).configAccessor.softLimit.getReverseSoftLimit() > this.m_position.get() : this.m_spark.getSparkModel() == SparkLowLevel.SparkModel.SparkMax && ((SparkMax)this.m_spark).configAccessor.softLimit.getReverseSoftLimitEnabled() && ((SparkMax)this.m_spark).configAccessor.softLimit.getReverseSoftLimit() > this.m_position.get()) {
            return true;
        }
        return this.getReverseLimitSwitchSim().getEnabled() && this.getReverseLimitSwitchSim().getPressed();
    }

    public void iterate(double velocity, double vbus, double dt) {
        if (vbus == 0.0) {
            DriverStation.reportError((String)("[REVLib Simulation error] " + this.m_deviceName + ": vbus provided to .iterate() cannot be zero"), (boolean)false);
            return;
        }
        double internalVelocity = NoiseGenerator.hallSensorVelocity(velocity);
        this.m_velocityAverage.put(internalVelocity, dt);
        internalVelocity = this.m_velocityAverage.get();
        this.m_velocity.set(internalVelocity);
        double positionFactor = 0.0;
        double velocityFactor = 0.0;
        if (this.m_spark.getSparkModel() == SparkLowLevel.SparkModel.SparkFlex) {
            if (((SparkFlex)this.m_spark).configAccessor.closedLoop.getFeedbackSensor() == FeedbackSensor.kAbsoluteEncoder) {
                positionFactor = ((SparkFlex)this.m_spark).configAccessor.absoluteEncoder.getPositionConversionFactor();
                velocityFactor = ((SparkFlex)this.m_spark).configAccessor.absoluteEncoder.getVelocityConversionFactor();
            } else {
                positionFactor = ((SparkFlex)this.m_spark).configAccessor.encoder.getPositionConversionFactor();
                velocityFactor = ((SparkFlex)this.m_spark).configAccessor.encoder.getVelocityConversionFactor();
            }
        } else if (this.m_spark.getSparkModel() == SparkLowLevel.SparkModel.SparkMax) {
            if (((SparkMax)this.m_spark).configAccessor.closedLoop.getFeedbackSensor() == FeedbackSensor.kAbsoluteEncoder) {
                positionFactor = ((SparkMax)this.m_spark).configAccessor.absoluteEncoder.getPositionConversionFactor();
                velocityFactor = ((SparkMax)this.m_spark).configAccessor.absoluteEncoder.getVelocityConversionFactor();
            } else {
                positionFactor = ((SparkMax)this.m_spark).configAccessor.encoder.getPositionConversionFactor();
                velocityFactor = ((SparkMax)this.m_spark).configAccessor.encoder.getVelocityConversionFactor();
            }
        }
        if (positionFactor == 0.0) {
            positionFactor = 1.0;
        }
        if (velocityFactor == 0.0) {
            velocityFactor = 1.0;
        }
        double velocityRPM = velocity / velocityFactor;
        this.m_position.set(this.m_position.get() + velocityRPM / 60.0 * dt * positionFactor);
        this.m_busVoltage.set(vbus);
        double appliedOutput = 0.0;
        switch (this.m_controlMode.get()) {
            case 0: {
                appliedOutput = this.m_setpoint.get();
                break;
            }
            case 1: {
                appliedOutput = CANSparkJNI.c_Spark_GetSimClosedLoopOutput(this.m_spark.sparkHandle, (float)this.m_setpoint.get(), (float)internalVelocity, (float)dt);
                break;
            }
            case 2: {
                appliedOutput = this.m_setpoint.get() / vbus;
                break;
            }
            case 3: {
                appliedOutput = CANSparkJNI.c_Spark_GetSimClosedLoopOutput(this.m_spark.sparkHandle, (float)this.m_setpoint.get(), (float)this.m_position.get(), (float)dt);
                break;
            }
            case 4: {
                appliedOutput = CANSparkJNI.c_Spark_GetSimClosedLoopOutput(this.m_spark.sparkHandle, (float)this.m_setpoint.get(), (float)this.m_motorCurrent.get(), (float)dt);
                break;
            }
            case 5: {
                appliedOutput = CANSparkJNI.c_Spark_GetSimMAXMotionPositionControlOutput(this.m_spark.sparkHandle, (float)dt);
                break;
            }
            case 6: {
                appliedOutput = CANSparkJNI.c_Spark_GetSimMAXMotionVelocityControlOutput(this.m_spark.sparkHandle, (float)dt);
                break;
            }
            default: {
                DriverStation.reportError((String)("[REVLib Simulation error] " + this.m_deviceName + ": Control mode out of bounds"), (boolean)false);
            }
        }
        appliedOutput = this.m_arbFFUnits.get() == 0 ? (appliedOutput += this.m_arbFF.get() / vbus) : (appliedOutput += this.m_arbFF.get());
        int VOLTAGE_COMP_MODE_ID = 74;
        if (CANSparkJNI.c_Spark_GetParameterUint32(this.m_spark.sparkHandle, VOLTAGE_COMP_MODE_ID) == 2) {
            if (this.m_spark.getSparkModel() == SparkLowLevel.SparkModel.SparkFlex) {
                appliedOutput = appliedOutput * ((SparkFlex)this.m_spark).configAccessor.getVoltageCompensation() / vbus;
            } else if (this.m_spark.getSparkModel() == SparkLowLevel.SparkModel.SparkMax) {
                appliedOutput = appliedOutput * ((SparkMax)this.m_spark).configAccessor.getVoltageCompensation() / vbus;
            }
        }
        double maxOutput = this.runLimitLogic(true) ? 0.0 : 1.0;
        double minOutput = this.runLimitLogic(false) ? 0.0 : -1.0;
        appliedOutput = Math.min(Math.max(appliedOutput, minOutput), maxOutput);
        appliedOutput = CANSparkJNI.c_Spark_GetSimCurrentLimitOutput(this.m_spark.sparkHandle, (float)appliedOutput, (float)this.m_motorCurrent.get());
        this.m_motorCurrent.set(this.m_dcMotor.getCurrent(Math.PI * velocityRPM / 30.0, appliedOutput * vbus));
        SparkBase.Faults motorFaults = this.m_spark.getFaults();
        SparkBase.Faults motorStickyFaults = this.m_spark.getStickyFaults();
        if (motorFaults.can || motorStickyFaults.can || motorFaults.escEeprom || motorStickyFaults.escEeprom || motorFaults.motorType || motorStickyFaults.motorType || motorFaults.firmware || motorStickyFaults.firmware || motorFaults.gateDriver || motorStickyFaults.gateDriver || motorFaults.sensor || motorStickyFaults.sensor || motorFaults.temperature || motorStickyFaults.temperature || motorFaults.other || motorStickyFaults.other) {
            appliedOutput = 0.0;
            DriverStation.reportWarning((String)("[REVLib Simulation] " + this.m_deviceName + ": Device stopped due to fault"), (boolean)false);
        }
        boolean doEnable = false;
        doEnable = this.m_enable == null ? DriverStation.isEnabled() : this.m_enable;
        if (doEnable) {
            this.m_appliedOutput.set(appliedOutput);
        } else {
            this.m_appliedOutput.set(0.0);
            this.m_motorCurrent.set(0.0);
        }
        FeedbackSensor selectedFeedbackSensor = this.m_spark.getSparkModel() == SparkLowLevel.SparkModel.SparkFlex ? ((SparkFlex)this.m_spark).configAccessor.closedLoop.getFeedbackSensor() : (this.m_spark.getSparkModel() == SparkLowLevel.SparkModel.SparkMax ? ((SparkMax)this.m_spark).configAccessor.closedLoop.getFeedbackSensor() : FeedbackSensor.kNoSensor);
        switch (selectedFeedbackSensor) {
            case kPrimaryEncoder: {
                SparkRelativeEncoderSim relativeEncoderSim = this.getRelativeEncoderSim();
                relativeEncoderSim.setPosition(this.m_position.get());
                relativeEncoderSim.setVelocity(this.m_velocity.get());
                break;
            }
            case kAnalogSensor: {
                SparkAnalogSensorSim analogSensorSim = this.getAnalogSensorSim();
                analogSensorSim.setPosition(this.m_position.get());
                analogSensorSim.setVelocity(this.m_velocity.get());
                break;
            }
            case kAlternateOrExternalEncoder: {
                if (this.m_spark.getSparkModel() == SparkLowLevel.SparkModel.SparkFlex) {
                    SparkFlexExternalEncoderSim externalEncoderSim = new SparkFlexSim((SparkFlex)this.m_spark, this.m_dcMotor).getExternalEncoderSim();
                    externalEncoderSim.setPosition(this.m_position.get());
                    externalEncoderSim.setVelocity(this.m_velocity.get());
                    break;
                }
                if (this.m_spark.getSparkModel() != SparkLowLevel.SparkModel.SparkMax) break;
                SparkMaxAlternateEncoderSim alternateEncoderSim = new SparkMaxSim((SparkMax)this.m_spark, this.m_dcMotor).getAlternateEncoderSim();
                alternateEncoderSim.setPosition(this.m_position.get());
                alternateEncoderSim.setVelocity(this.m_velocity.get());
                break;
            }
            case kAbsoluteEncoder: {
                SparkAbsoluteEncoderSim absoluteEncoderSim = this.getAbsoluteEncoderSim();
                absoluteEncoderSim.setPosition(this.m_position.get());
                absoluteEncoderSim.setVelocity(this.m_velocity.get());
                break;
            }
        }
    }

    public double getVelocity() {
        return this.m_velocity.get();
    }

    public void setVelocity(double velocity) {
        this.m_velocity.set(velocity);
    }

    public double getPosition() {
        return this.m_position.get();
    }

    public void setPosition(double position) {
        this.m_position.set(position);
    }

    public double getBusVoltage() {
        return this.m_busVoltage.get();
    }

    public void setBusVoltage(double voltage) {
        this.m_busVoltage.set(voltage);
    }

    public double getMotorCurrent() {
        return this.m_motorCurrent.get();
    }

    public void setMotorCurrent(double current) {
        this.m_motorCurrent.set(current);
    }

    public void enable() {
        this.m_enable = true;
    }

    public void disable() {
        this.m_enable = false;
    }

    public void useDriverStationEnable() {
        this.m_enable = null;
    }

    public SparkRelativeEncoderSim getRelativeEncoderSim() {
        CANSparkJNI.c_Spark_CreateRelativeEncoderSim(this.m_spark.sparkHandle);
        if (this.m_spark.getSparkModel() == SparkLowLevel.SparkModel.SparkMax) {
            return new SparkRelativeEncoderSim((SparkMax)this.m_spark);
        }
        if (this.m_spark.getSparkModel() == SparkLowLevel.SparkModel.SparkFlex) {
            return new SparkRelativeEncoderSim((SparkFlex)this.m_spark);
        }
        DriverStation.reportError((String)("[REVLib Simulation error] " + this.m_deviceName + ": Unknown Device Type"), (boolean)false);
        return null;
    }

    public SparkAbsoluteEncoderSim getAbsoluteEncoderSim() {
        CANSparkJNI.c_Spark_CreateAbsoluteEncoderSim(this.m_spark.sparkHandle);
        if (this.m_spark.getSparkModel() == SparkLowLevel.SparkModel.SparkMax) {
            return new SparkAbsoluteEncoderSim((SparkMax)this.m_spark);
        }
        if (this.m_spark.getSparkModel() == SparkLowLevel.SparkModel.SparkFlex) {
            return new SparkAbsoluteEncoderSim((SparkFlex)this.m_spark);
        }
        DriverStation.reportError((String)("[REVLib Simulation error] " + this.m_deviceName + ": Unknown Device Type"), (boolean)false);
        return null;
    }

    public SparkAnalogSensorSim getAnalogSensorSim() {
        CANSparkJNI.c_Spark_CreateAnalogSensorSim(this.m_spark.sparkHandle);
        if (this.m_spark.getSparkModel() == SparkLowLevel.SparkModel.SparkMax) {
            return new SparkAnalogSensorSim((SparkMax)this.m_spark);
        }
        if (this.m_spark.getSparkModel() == SparkLowLevel.SparkModel.SparkFlex) {
            return new SparkAnalogSensorSim((SparkFlex)this.m_spark);
        }
        DriverStation.reportError((String)("[REVLib Simulation error] " + this.m_deviceName + ": Unknown Device Type"), (boolean)false);
        return null;
    }

    public SparkLimitSwitchSim getForwardLimitSwitchSim() {
        if (this.m_spark.getSparkModel() == SparkLowLevel.SparkModel.SparkMax) {
            return new SparkLimitSwitchSim((SparkMax)this.m_spark, true);
        }
        if (this.m_spark.getSparkModel() == SparkLowLevel.SparkModel.SparkFlex) {
            return new SparkLimitSwitchSim((SparkFlex)this.m_spark, true);
        }
        DriverStation.reportError((String)("[REVLib Simulation error] " + this.m_deviceName + ": Unknown Device Type"), (boolean)false);
        return null;
    }

    public SparkLimitSwitchSim getReverseLimitSwitchSim() {
        if (this.m_spark.getSparkModel() == SparkLowLevel.SparkModel.SparkMax) {
            return new SparkLimitSwitchSim((SparkMax)this.m_spark, false);
        }
        if (this.m_spark.getSparkModel() == SparkLowLevel.SparkModel.SparkFlex) {
            return new SparkLimitSwitchSim((SparkFlex)this.m_spark, false);
        }
        DriverStation.reportError((String)("[REVLib Simulation error] " + this.m_deviceName + ": Unknown Device Type"), (boolean)false);
        return null;
    }

    public SparkSimFaultManager getFaultManager() {
        if (this.m_spark.getSparkModel() == SparkLowLevel.SparkModel.SparkMax) {
            return new SparkSimFaultManager((SparkMax)this.m_spark);
        }
        if (this.m_spark.getSparkModel() == SparkLowLevel.SparkModel.SparkFlex) {
            return new SparkSimFaultManager((SparkFlex)this.m_spark);
        }
        DriverStation.reportError((String)("[REVLib Simulation error] " + this.m_deviceName + ": Unknown Device Type"), (boolean)false);
        return null;
    }
}

