/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.revlib.support;

import com.revrobotics.canbridge.CanBridge;
import com.revrobotics.canbridge.CanBus;
import com.revrobotics.canbridge.CanMessage;
import com.revrobotics.canbridge.CanMode;
import com.revrobotics.revlib.support.Callbacks;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import java.util.List;

public interface CallbackDriver
extends Library {
    public static final int SUCCESS_CODE = 0;
    public static final int NO_MESSAGE_CODE = 1;
    public static final CallbackDriver INSTANCE = CallbackDriver.loadCallbackDriver();
    public static final CanBridgeHolder canBridgeHolder = new CanBridgeHolder();

    public Pointer createCallbackDriver(CallbackPointers.ByReference var1);

    private static CallbackDriver loadCallbackDriver() {
        try {
            System.loadLibrary("CallbackDriver");
        }
        catch (UnsatisfiedLinkError e) {
            String path = NativeLibrary.getInstance((String)"CallbackDriver", (ClassLoader)CallbackDriver.class.getClassLoader()).getFile().getAbsolutePath();
            System.load(path);
        }
        return (CallbackDriver)Native.load((String)"CallbackDriver", CallbackDriver.class);
    }

    public static CallbackPointers.ByReference createCallbacks() {
        CallbackPointers.ByReference pointers = new CallbackPointers.ByReference();
        pointers.writeFrame = (messageId, data, dataSize, periodMs, isRtr, status) -> {
            byte[] dataArray = data == null ? new byte[]{} : data.getByteArray(0L, (int)dataSize);
            CanMessage message = new CanMessage(messageId, CallbackDriver.getCanTime(), isRtr != 0, CanMode.CLASSIC, dataArray);
            CanBus bus = CallbackDriver.getFirstBus();
            if (bus == null) {
                return;
            }
            CallbackDriver.canBridgeHolder.canBridge.sendMessage(bus, message, periodMs);
        };
        pointers.readFrameLatest = (messageId, messageMask, data, dataSize, timestamp, status) -> {
            status.setValue(1);
            CanBus bus = CallbackDriver.getFirstBus();
            if (bus == null) {
                return;
            }
            CanMessage message = CallbackDriver.canBridgeHolder.canBridge.getLatestMessage(bus, messageId.getValue(), messageMask);
            if (message == null) {
                status.setValue(1);
                return;
            }
            timestamp.setValue(message.timestamp());
            messageId.setValue(message.messageId());
            for (int i = 0; i < message.data().length; ++i) {
                data.setByte((long)i, message.data()[i]);
            }
            dataSize.setValue((byte)message.data().length);
            status.setValue(0);
        };
        pointers.readFrameTimeout = (messageId, messageMask, data, dataSize, timestamp, timeout, status) -> {
            status.setValue(1);
            CanBus bus = CallbackDriver.getFirstBus();
            if (bus == null) {
                return;
            }
            CanMessage message = CallbackDriver.canBridgeHolder.canBridge.getLatestMessage(bus, messageId.getValue(), messageMask);
            if (message == null || Integer.toUnsignedLong((int)CallbackDriver.getCanTime() - (int)message.timestamp()) >= (long)timeout) {
                status.setValue(1);
                return;
            }
            timestamp.setValue(message.timestamp());
            messageId.setValue(message.messageId());
            for (int i = 0; i < message.data().length; ++i) {
                data.setByte((long)i, message.data()[i]);
            }
            dataSize.setValue((byte)message.data().length);
            status.setValue(0);
        };
        pointers.readFrameNew = (messageId, data, dataSize, timestamp, status) -> {
            status.setValue(1);
            CanBus bus = CallbackDriver.getFirstBus();
            if (bus == null) {
                return;
            }
            CanMessage message = CallbackDriver.canBridgeHolder.canBridge.getLatestMessage(bus, messageId, 0x1FFFFFFF);
            if (message == null) {
                status.setValue(1);
                return;
            }
            timestamp.setValue(message.timestamp());
            for (int i = 0; i < message.data().length; ++i) {
                data.setByte((long)i, message.data()[i]);
            }
            dataSize.setValue((byte)message.data().length);
            status.setValue(0);
        };
        pointers.getCurrentTime = CallbackDriver::getCanTime;
        pointers.getCanTime = () -> (int)CallbackDriver.getCanTime();
        return pointers;
    }

    public static CanBus getFirstBus() {
        if (CallbackDriver.canBridgeHolder.canBridge == null) {
            return null;
        }
        CanBus[] buses = CallbackDriver.canBridgeHolder.canBridge.getBuses();
        return buses.length == 0 ? null : buses[0];
    }

    private static long getCanTime() {
        return (int)System.currentTimeMillis();
    }

    public static class CallbackPointers
    extends Structure {
        public Callbacks.WriteFrame writeFrame;
        public Callbacks.ReadFrameLatest readFrameLatest;
        public Callbacks.ReadFrameTimeout readFrameTimeout;
        public Callbacks.ReadFrameNew readFrameNew;
        public Callbacks.GetCurrentTime getCurrentTime;
        public Callbacks.GetCanTime getCanTime;

        protected List<String> getFieldOrder() {
            return List.of("writeFrame", "readFrameLatest", "readFrameTimeout", "readFrameNew", "getCurrentTime", "getCanTime");
        }

        public static class ByReference
        extends CallbackPointers
        implements Structure.ByReference {
        }
    }

    public static class CanBridgeHolder {
        public CanBridge canBridge;
    }
}

