/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics;

import com.revrobotics.canbridge.CanBridge;
import com.revrobotics.canbridge.CanBus;
import com.revrobotics.canbridge.CanMessage;

public record CanFrameUtils(CanBridge bridge, CanBus bus) {
    public CanMessage sendAndAwaitResponse(CanMessage canMessage, int responseId, int timeout) {
        CanMessage lastOfSameId = this.bridge.getLatestMessage(this.bus, responseId, 0x1FFFFFFF);
        this.bridge.sendMessage(this.bus, canMessage);
        this.bridge.sendMessage(this.bus, canMessage);
        long startTime = System.currentTimeMillis();
        do {
            CanMessage responseCandidate;
            if ((responseCandidate = this.bridge.getLatestMessage(this.bus, responseId, 0x1FFFFFFF)) == null || responseCandidate.isRtr() || lastOfSameId != null && responseCandidate.timestamp() == lastOfSameId.timestamp()) continue;
            return responseCandidate;
        } while (System.currentTimeMillis() - startTime <= (long)timeout);
        return null;
    }
}

