/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics;

import com.revrobotics.StatusFrameEmitter;
import com.revrobotics.devices.PowerHub;
import java.util.UUID;

public class PowerHubStatusEmitter
extends StatusFrameEmitter {
    private final PowerHub powerHub;
    private final StatusDataCallback statusDataCallback;
    private final String descriptor;
    private final UUID uuid;
    private final String messageName;

    public PowerHubStatusEmitter(String descriptor, UUID uuid, PowerHub powerHub, StatusDataCallback statusDataCallback, StatusFrameEmitter.OnStopCallback onStopCallback) {
        super(onStopCallback, 5);
        this.powerHub = powerHub;
        this.statusDataCallback = statusDataCallback;
        this.descriptor = descriptor;
        this.uuid = uuid;
        this.messageName = "Power Hub " + powerHub.getDeviceId();
    }

    private Status0 getStatus0() {
        PowerHub.Status0 frame = this.powerHub.getStatus0();
        if (frame == null) {
            return null;
        }
        return new Status0(frame.channel0Current(), frame.channel1Current(), frame.channel2Current(), frame.channel3Current(), frame.channel4Current(), frame.channel5Current(), frame.channel0BreakerFault(), frame.channel1BreakerFault(), frame.channel2BreakerFault(), frame.channel3BreakerFault());
    }

    private Status1 getStatus1() {
        PowerHub.Status1 frame = this.powerHub.getStatus1();
        if (frame == null) {
            return null;
        }
        return new Status1(frame.channel6Current(), frame.channel7Current(), frame.channel8Current(), frame.channel9Current(), frame.channel10Current(), frame.channel11Current(), frame.channel4BreakerFault(), frame.channel5BreakerFault(), frame.channel6BreakerFault(), frame.channel7BreakerFault());
    }

    private Status2 getStatus2() {
        PowerHub.Status2 frame = this.powerHub.getStatus2();
        if (frame == null) {
            return null;
        }
        return new Status2(frame.channel12Current(), frame.channel13Current(), frame.channel14Current(), frame.channel15Current(), frame.channel16Current(), frame.channel17Current(), frame.channel8BreakerFault(), frame.channel9BreakerFault(), frame.channel10BreakerFault(), frame.channel11BreakerFault());
    }

    private Status3 getStatus3() {
        PowerHub.Status3 frame = this.powerHub.getStatus3();
        if (frame == null) {
            return null;
        }
        return new Status3(frame.channel18Current(), frame.channel19Current(), frame.channel20Current(), frame.channel21Current(), frame.channel22Current(), frame.channel23Current(), frame.channel12BreakerFault(), frame.channel13BreakerFault(), frame.channel14BreakerFault(), frame.channel15BreakerFault(), frame.channel16BreakerFault(), frame.channel17BreakerFault(), frame.channel18BreakerFault(), frame.channel19BreakerFault(), frame.channel20BreakerFault(), frame.channel21BreakerFault(), frame.channel22BreakerFault(), frame.channel23BreakerFault());
    }

    private Status4 getStatus4() {
        PowerHub.Status4 frame = this.powerHub.getStatus4();
        if (frame == null) {
            return null;
        }
        return new Status4(frame.vbus(), frame.totalCurrent(), frame.enabled(), frame.roboRioPresent(), frame.brownoutFault(), frame.cANWarning(), frame.hardwareFault(), frame.switchableChannelState(), frame.stickyBrownoutFault(), frame.stickyCANWarning(), frame.stickyBusOffFault(), frame.stickyHardwareFault(), frame.stickyFirmwareFault(), frame.stickyChannel20BreakerFault(), frame.stickyChannel21BreakerFault(), frame.stickyChannel22BreakerFault(), frame.stickyChannel23BreakerFault(), frame.stickyResetFault(), frame.stickyChannel0BreakerFault(), frame.stickyChannel1BreakerFault(), frame.stickyChannel2BreakerFault(), frame.stickyChannel3BreakerFault(), frame.stickyChannel4BreakerFault(), frame.stickyChannel5BreakerFault(), frame.stickyChannel6BreakerFault(), frame.stickyChannel7BreakerFault(), frame.stickyChannel8BreakerFault(), frame.stickyChannel9BreakerFault(), frame.stickyChannel10BreakerFault(), frame.stickyChannel11BreakerFault(), frame.stickyChannel12BreakerFault(), frame.stickyChannel13BreakerFault(), frame.stickyChannel14BreakerFault(), frame.stickyChannel15BreakerFault(), frame.stickyChannel16BreakerFault(), frame.stickyChannel17BreakerFault(), frame.stickyChannel18BreakerFault(), frame.stickyChannel19BreakerFault());
    }

    @Override
    public void runFrameEmitter() {
        try {
            Status1 powerHubStatus1 = null;
            Status2 powerHubStatus2 = null;
            Status3 powerHubStatus3 = null;
            Status4 powerHubStatus4 = null;
            if (this.frameEnabled[1]) {
                powerHubStatus1 = this.getStatus1();
            }
            if (this.frameEnabled[2]) {
                powerHubStatus2 = this.getStatus2();
            }
            if (this.frameEnabled[3]) {
                powerHubStatus3 = this.getStatus3();
            }
            if (this.frameEnabled[4]) {
                powerHubStatus4 = this.getStatus4();
            }
            Data statusData = new Data(this.getStatus0(), powerHubStatus1, powerHubStatus2, powerHubStatus3, powerHubStatus4);
            PowerHubStatusData data = new PowerHubStatusData(this.getTimestamp(), this.messageName, this.descriptor, this.uuid, statusData);
            if (this.statusDataCallback != null) {
                this.statusDataCallback.onPowerHubStatusData(data);
            }
        }
        catch (IllegalStateException e) {
            this.stop();
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println("Attempted to access invalid status frame. Check for programming error");
            this.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected String getThreadName() {
        return "PowerHubStatusFrameEmitter(" + this.powerHub.getDeviceId() + ")";
    }

    public static interface StatusDataCallback {
        public void onPowerHubStatusData(PowerHubStatusData var1);
    }

    public record Status0(double channel0Current, double channel1Current, double channel2Current, double channel3Current, double channel4Current, double channel5Current, boolean channel0BreakerFault, boolean channel1BreakerFault, boolean channel2BreakerFault, boolean channel3BreakerFault) {
    }

    public record Status1(double channel6Current, double channel7Current, double channel8Current, double channel9Current, double channel10Current, double channel11Current, boolean channel4BreakerFault, boolean channel5BreakerFault, boolean channel6BreakerFault, boolean channel7BreakerFault) {
    }

    public record Status2(double channel12Current, double channel13Current, double channel14Current, double channel15Current, double channel16Current, double channel17Current, boolean channel8BreakerFault, boolean channel9BreakerFault, boolean channel10BreakerFault, boolean channel11BreakerFault) {
    }

    public record Status3(double channel18Current, double channel19Current, double channel20Current, double channel21Current, double channel22Current, double channel23Current, boolean channel12BreakerFault, boolean channel13BreakerFault, boolean channel14BreakerFault, boolean channel15BreakerFault, boolean channel16BreakerFault, boolean channel17BreakerFault, boolean channel18BreakerFault, boolean channel19BreakerFault, boolean channel20BreakerFault, boolean channel21BreakerFault, boolean channel22BreakerFault, boolean channel23BreakerFault) {
    }

    public record Status4(double busVoltage, double current, boolean deviceEnabled, boolean roborioEnabled, boolean brownoutFault, boolean canWarning, boolean hardwareFault, boolean switchableChannelState, boolean stickyBrownoutFault, boolean stickyCanWarning, boolean stickyBusOffFault, boolean stickyHardwareFault, boolean stickyFirmwareFault, boolean stickyChannel20Fault, boolean stickyChannel21Fault, boolean stickyChannel22Fault, boolean stickyChannel23Fault, boolean stickyReset, boolean stickyChannel0Fault, boolean stickyChannel1Fault, boolean stickyChannel2Fault, boolean stickyChannel3Fault, boolean stickyChannel4Fault, boolean stickyChannel5Fault, boolean stickyChannel6Fault, boolean stickyChannel7Fault, boolean stickyChannel8Fault, boolean stickyChannel9Fault, boolean stickyChannel10Fault, boolean stickyChannel11Fault, boolean stickyChannel12Fault, boolean stickyChannel13Fault, boolean stickyChannel14Fault, boolean stickyChannel15Fault, boolean stickyChannel16Fault, boolean stickyChannel17Fault, boolean stickyChannel18Fault, boolean stickyChannel19Fault) {
    }

    public record Data(Status0 status0, Status1 status1, Status2 status2, Status3 status3, Status4 status4) {
    }

    public record PowerHubStatusData(double timestamp, String name, String descriptor, UUID uuid, Data data) {
    }
}

