/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics;

import com.revrobotics.CanFrameUtils;
import com.revrobotics.SparkCanSpec;
import com.revrobotics.canbridge.CanBridge;
import com.revrobotics.canbridge.CanBus;
import com.revrobotics.canbridge.CanMessage;

public abstract class SparkAdvanced {
    private static final int NUM_ATTEMPTS = 3;

    public static void enterDfuBootloader(CanBridge bridge, CanBus bus, int deviceId) {
        byte[] data = new byte[]{69, -6};
        CanMessage message = CanMessage.createClassic((int)(33893632 + deviceId), (byte[])data);
        bridge.sendMessage(bus, message);
    }

    public static void identify(CanBridge bridge, CanBus bus, int deviceId) {
        byte[] data = new byte[]{};
        CanMessage message = CanMessage.createClassic((int)(33889728 + deviceId), (byte[])data);
        bridge.sendMessage(bus, message);
    }

    public static boolean checkIfUsbBridge(CanBridge bridge, CanBus bus, int deviceId) {
        CanFrameUtils utils = new CanFrameUtils(bridge, bus);
        byte[] data = new byte[0];
        CanMessage message = CanMessage.createRtr((int)(33893568 + deviceId), (byte[])data);
        CanMessage response = utils.sendAndAwaitResponse(message, message.messageId(), 200);
        return response != null;
    }

    public static boolean fullFactoryResetWithRetries(CanBridge bridge, CanBus bus, int deviceId) {
        for (int i = 0; i < 3; ++i) {
            boolean result = SparkAdvanced.fullFactoryReset(bridge, bus, deviceId);
            if (!result) continue;
            return true;
        }
        return false;
    }

    public static boolean fullFactoryReset(CanBridge bridge, CanBus bus, int deviceId) {
        CanFrameUtils utils = new CanFrameUtils(bridge, bus);
        byte[] data = new byte[]{45, 116};
        CanMessage message = CanMessage.createClassic((int)(33883584 + deviceId), (byte[])data);
        CanMessage response = utils.sendAndAwaitResponse(message, 33883648 + deviceId, 5000);
        if (response == null) {
            return false;
        }
        SparkCanSpec.CompleteFactoryResetResponse responseData = SparkCanSpec.completeFactoryResetResponseUnpack(response.data());
        return responseData.resultCode() == 0;
    }

    public static SparkModel getModel(CanMessage message) {
        SparkCanSpec.Status0 status0 = SparkCanSpec.status0Unpack(message.data());
        return switch (status0.sparkModel()) {
            case 1 -> SparkModel.SPARK_FLEX;
            case 2 -> SparkModel.SPARK_MAX;
            default -> SparkModel.UNKNOWN;
        };
    }

    public static SparkFirmwareVersion getFirmwareVersion(CanBridge bridge, CanBus bus, int deviceId) {
        for (int i = 0; i < 3; ++i) {
            SparkFirmwareVersion result = SparkAdvanced.getFirmwareVersionOrNull(bridge, bus, deviceId);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static SparkFirmwareVersion getFirmwareVersionOrNull(CanBridge bridge, CanBus bus, int deviceId) {
        CanFrameUtils utils = new CanFrameUtils(bridge, bus);
        byte[] data = new byte[8];
        CanMessage message = CanMessage.createRtr((int)(33891840 + deviceId), (byte[])data);
        CanMessage response = utils.sendAndAwaitResponse(message, message.messageId(), 500);
        if (response == null) {
            return null;
        }
        SparkCanSpec.GetFirmwareVersion version = SparkCanSpec.getFirmwareVersionUnpack(response.data());
        short build = Short.reverseBytes((short)version.build());
        return new SparkFirmwareVersion(version.major(), version.minor(), build, version.debugBuild());
    }

    public static int readParameterInt32(CanBridge bridge, CanBus bus, int deviceId, int index) {
        Integer result = SparkAdvanced.getParameterReadResponseDataWithRetry(bridge, bus, deviceId, index, 3);
        if (result == null) {
            throw new IllegalStateException("Device did not respond with parameter value");
        }
        return result;
    }

    public static float readParameterFloat(CanBridge bridge, CanBus bus, int deviceId, int index) {
        int result = SparkAdvanced.readParameterInt32(bridge, bus, deviceId, index);
        return Float.intBitsToFloat(result);
    }

    public static boolean readParameterBool(CanBridge bridge, CanBus bus, int deviceId, int index) {
        return SparkAdvanced.readParameterInt32(bridge, bus, deviceId, index) != 0;
    }

    private static Integer getParameterReadResponseDataWithRetry(CanBridge bridge, CanBus bus, int deviceId, int index, int retries) {
        for (int i = 0; i < retries; ++i) {
            Integer value = SparkAdvanced.getParameterReadResponseData(bridge, bus, deviceId, index);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    private static Integer getParameterReadResponseData(CanBridge bridge, CanBus bus, int deviceId, int index) {
        CanFrameUtils utils = new CanFrameUtils(bridge, bus);
        int paramId = 33897472 + (index / 2 << 6);
        byte[] data = new byte[8];
        CanMessage message = CanMessage.createRtr((int)(paramId + deviceId), (byte[])data);
        CanMessage response = utils.sendAndAwaitResponse(message, message.messageId(), 1000);
        if (response == null) {
            return null;
        }
        int offset = index % 2 == 0 ? 0 : 4;
        byte[] responseData = response.data();
        return (responseData[3 + offset] & 0xFF) << 24 | (responseData[2 + offset] & 0xFF) << 16 | (responseData[1 + offset] & 0xFF) << 8 | responseData[offset] & 0xFF;
    }

    public static enum SparkModel {
        SPARK_FLEX,
        SPARK_MAX,
        UNKNOWN;

    }

    public record SparkFirmwareVersion(int major, int minor, int fix, int prerelease) {
    }
}

