/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.device.detection;

import com.revrobotics.EncoderAdvanced;
import com.revrobotics.ServoHubAdvanced;
import com.revrobotics.SparkAdvanced;
import com.revrobotics.canbridge.CanBridge;
import com.revrobotics.canbridge.CanBridgeCallback;
import com.revrobotics.canbridge.CanBus;
import com.revrobotics.canbridge.CanMessage;
import com.revrobotics.device.detection.AllCanFrames;
import com.revrobotics.device.detection.CanBusData;
import com.revrobotics.device.detection.device.DeviceTree;
import com.revrobotics.device.detection.device.DeviceType;
import com.revrobotics.device.detection.device.FRCCanDevice;
import com.revrobotics.device.detection.device.Manufacturer;
import com.revrobotics.device.detection.device.RecognizedDevice;
import com.revrobotics.device.detection.dfu.DfuDevice;
import com.revrobotics.device.detection.dfu.DfuManager;
import com.revrobotics.device.detection.gsusb.GSUsbManager;
import com.revrobotics.device.detection.parsing.CanIdParsing;
import com.revrobotics.devices.PneumaticHub;
import com.revrobotics.devices.PowerHub;
import com.revrobotics.spark.config.SparkParameters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Detector {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final DfuManager dfuManager;
    private final List<DfuDevice> dfuUpdatingDevices = new CopyOnWriteArrayList<DfuDevice>();
    private final List<StagedCallback> scanCallbacks = new ArrayList<StagedCallback>();
    private final List<DeviceTree> detectedDevices = new ArrayList<DeviceTree>();
    final CanBridge canBridge;
    private final GSUsbManager gsUsbManager;

    public Detector(CanBridge bridge, DfuManager dfuManager, GSUsbManager gsUsbManager) {
        this.canBridge = bridge;
        this.dfuManager = dfuManager;
        this.gsUsbManager = gsUsbManager;
        this.addScanCallback(DetectorStage.DEVICES_DETECTED, (devices, newDevices, removedDevices, changedDevices) -> this.logger.log(Level.INFO, "Detected devices: " + String.valueOf(devices)));
    }

    private boolean isRelevantDfu(DfuDevice device) {
        return device.vid() == 1155 && device.pid() == 57105 && device.alt() == 0;
    }

    public void iterate(AllCanFrames allFrames) {
        DeviceTree newTree;
        Optional<DeviceTree> matchingDeviceTree;
        List<DfuDevice> dfuDevices = this.dfuManager.listDevices();
        dfuDevices = dfuDevices.stream().filter(this::isRelevantDfu).toList();
        List<GSUsbManager.GsUsbDevice> gsUsbDevices = this.gsUsbManager != null ? this.gsUsbManager.listGsUsbDevices() : List.of();
        List<DeviceTree> removedDevices = this.removeDevicesNotInScan(allFrames, dfuDevices, gsUsbDevices);
        ArrayList<DeviceTree> addedDevices = new ArrayList<DeviceTree>();
        ArrayList<DeviceTree> changedDevices = new ArrayList<DeviceTree>();
        for (CanBusData canBusData : allFrames.allMessages().values()) {
            Optional<DeviceTree> matchingBus = this.detectedDevices.stream().filter(device -> device.descriptor().equals(entry.descriptor())).findFirst();
            if (matchingBus.isEmpty()) {
                DeviceTree newDevice = this.addNewDevice(canBusData);
                if (newDevice == null) continue;
                addedDevices.add(newDevice);
                continue;
            }
            List<FRCCanDevice> devicesOnBusNow = this.findCanDevices(canBusData.descriptor(), canBusData.messages());
            if (matchingBus.get().busMatches(devicesOnBusNow)) continue;
            this.detectedDevices.remove(matchingBus.get());
            DeviceTree tree2 = this.addNewDevice(canBusData);
            if (tree2 == null) continue;
            changedDevices.add(tree2);
        }
        for (DfuDevice dfuDevice : dfuDevices) {
            matchingDeviceTree = this.detectedDevices.stream().filter(tree -> Objects.equals(tree.descriptor(), dfuDevice.serial())).findFirst();
            if (!matchingDeviceTree.isEmpty()) continue;
            FRCCanDevice dfuDevice2 = Detector.createDfuDevice(dfuDevice);
            newTree = new DeviceTree(dfuDevice2, dfuDevice.serial(), Collections.emptyList());
            this.detectedDevices.add(newTree);
            addedDevices.add(newTree);
        }
        for (DfuDevice dfuDevice : this.dfuUpdatingDevices) {
            if (!this.detectedDevices.stream().noneMatch(tree -> tree.root().descriptor().equals(dfuDevice.serial()))) continue;
            FRCCanDevice dfuDevice3 = Detector.createDfuDevice(dfuDevice);
            DeviceTree newTree2 = new DeviceTree(dfuDevice3, dfuDevice.serial(), Collections.emptyList());
            this.detectedDevices.add(newTree2);
            addedDevices.add(newTree2);
        }
        for (GSUsbManager.GsUsbDevice gsUsbDevice : gsUsbDevices) {
            matchingDeviceTree = this.detectedDevices.stream().filter(tree -> Objects.equals(tree.descriptor(), gsUsbDevice.descriptor())).findFirst();
            if (!matchingDeviceTree.isEmpty()) continue;
            FRCCanDevice gsUsbDevice2 = new FRCCanDevice(gsUsbDevice.descriptor(), 0, false, RecognizedDevice.GS_USB, UUID.randomUUID());
            newTree = new DeviceTree(gsUsbDevice2, gsUsbDevice.descriptor(), Collections.emptyList());
            this.detectedDevices.add(newTree);
            addedDevices.add(newTree);
        }
        if (!(changedDevices.isEmpty() && addedDevices.isEmpty() && removedDevices.isEmpty())) {
            Thread t = this.createCallbackThread(addedDevices, removedDevices, changedDevices);
            t.start();
        }
    }

    private Thread createCallbackThread(List<DeviceTree> addedDevices, List<DeviceTree> removedDevices, List<DeviceTree> changedDevices) {
        ArrayList<StagedCallback> callbacks = new ArrayList<StagedCallback>(this.scanCallbacks);
        Thread t = new Thread(() -> {
            try {
                callbacks.forEach(stagedCallback -> stagedCallback.callback.onNewScanResult(List.copyOf(this.detectedDevices), List.copyOf(addedDevices), List.copyOf(removedDevices), List.copyOf(changedDevices)));
            }
            catch (Exception e) {
                this.logger.severe("Exception while processing callbacks: " + e.getMessage());
                e.printStackTrace();
            }
        });
        t.setName("Scan callback thread");
        t.setDaemon(true);
        return t;
    }

    private static FRCCanDevice createDfuDevice(DfuDevice device) {
        return new FRCCanDevice(device.serial(), 0, true, RecognizedDevice.DFU, UUID.nameUUIDFromBytes("DFU".getBytes()));
    }

    private List<DeviceTree> removeDevicesNotInScan(AllCanFrames allFrames, List<DfuDevice> dfuDevices, List<GSUsbManager.GsUsbDevice> gsUsbDevices) {
        Predicate<DeviceTree> predicate = device -> this.frcCanDeviceCanBeRemoved(allFrames, (DeviceTree)device) || this.dfuDeviceCanBeRemoved(dfuDevices, (DeviceTree)device) || this.gsUsbDeviceCanBeRemoved(gsUsbDevices, (DeviceTree)device);
        List<DeviceTree> toRemove = this.detectedDevices.stream().filter(predicate).toList();
        this.detectedDevices.removeIf(predicate);
        return toRemove;
    }

    private boolean dfuDeviceCanBeRemoved(List<DfuDevice> dfuDevices, DeviceTree device) {
        return this.isDfuDevice(device) && dfuDevices.stream().noneMatch(d -> d.serial().equals(device.descriptor())) && this.dfuUpdatingDevices.stream().noneMatch(d -> d.serial().equals(device.descriptor()));
    }

    private boolean frcCanDeviceCanBeRemoved(AllCanFrames allFrames, DeviceTree device) {
        return RecognizedDevice.isCan(device.root().type()) && !allFrames.allMessages().containsKey(device.descriptor());
    }

    private boolean gsUsbDeviceCanBeRemoved(List<GSUsbManager.GsUsbDevice> gsUsbDevices, DeviceTree device) {
        return RecognizedDevice.isGsUsb(device.root().type()) && gsUsbDevices.stream().noneMatch(gsUsbDevice -> gsUsbDevice.descriptor().equals(device.descriptor()));
    }

    private boolean isDfuDevice(DeviceTree device) {
        if (device.root() == null) {
            return false;
        }
        return device.root().type() == RecognizedDevice.DFU;
    }

    private DeviceTree addNewDevice(CanBusData frames) {
        List<FRCCanDevice> devices = this.findCanDevices(frames.descriptor(), frames.messages());
        if (!devices.isEmpty()) {
            FRCCanDevice root = this.findRoot(frames.descriptor(), devices);
            devices.remove(root);
            DeviceTree device = new DeviceTree(root, frames.descriptor(), devices);
            this.detectedDevices.add(device);
            return device;
        }
        return null;
    }

    private FRCCanDevice findRoot(String descriptor, List<FRCCanDevice> devices) {
        CanBus bus = this.canBridge.getBusOrNull(descriptor);
        for (FRCCanDevice device : devices) {
            boolean isBridge;
            boolean bl;
            block15: {
                block14: {
                    if (device == null || device.type() == null) break block14;
                    switch (device.type()) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case SPARK_FLEX: 
                        case SPARK_MAX: 
                        case UNKNOWN_SPARK: {
                            if (SparkAdvanced.checkIfUsbBridge((CanBridge)this.canBridge, (CanBus)bus, (int)device.id())) {
                                break;
                            }
                            break block14;
                        }
                        case SERVO_HUB: {
                            if (ServoHubAdvanced.checkIfUsbBridge((CanBridge)this.canBridge, (CanBus)bus, (int)device.id())) {
                                break;
                            }
                            break block14;
                        }
                        case PDH: {
                            if (PowerHub.checkIfUsbBridge((CanBridge)this.canBridge, (CanBus)bus, (int)device.id())) {
                                break;
                            }
                            break block14;
                        }
                        case PH: {
                            if (PneumaticHub.checkIfUsbBridge((CanBridge)this.canBridge, (CanBus)bus, (int)device.id())) {
                                break;
                            }
                            break block14;
                        }
                        case UNKNOWN_ENCODER: 
                        case MAXSPLINE_ENCODER: {
                            break block14;
                        }
                        case DFU: 
                        case GS_USB: {
                            break;
                        }
                        case ROBORIO: 
                        case CONTROL_HUB: 
                        case EXPANSION_HUB: 
                        case REV_FIRMWARE_INTERFACE: 
                        case CTRE_DEVICE: 
                        case THRIFTY_DEVICE: 
                        case FUSION_DEVICE: 
                        case STUDICA_DEVICE: 
                        case REDUX_DEVICE: 
                        case SWYFT_DEVICE: {
                            break block14;
                        }
                    }
                    bl = true;
                    break block15;
                }
                bl = false;
            }
            if (!(isBridge = bl)) continue;
            return device;
        }
        return devices.getFirst();
    }

    public static UUID deviceUUID(int id, DeviceType type, Manufacturer manufacturer) {
        String text = Integer.toHexString(id) + type.name() + manufacturer.name();
        return UUID.nameUUIDFromBytes(text.getBytes());
    }

    private List<FRCCanDevice> findCanDevices(String descriptor, List<CanMessage> messages) {
        ArrayList<FRCCanDevice> canDevices = new ArrayList<FRCCanDevice>();
        for (CanMessage message : messages) {
            CanBus bus;
            int deviceId = CanIdParsing.parseDeviceId(message.messageId());
            DeviceType deviceType = CanIdParsing.parseDeviceType(message.messageId());
            Manufacturer manufacturer = CanIdParsing.manufacturer(message.messageId());
            boolean isBootloader = false;
            RecognizedDevice recognizedDevice = RecognizedDevice.fromCanInfo(manufacturer, deviceType);
            if (recognizedDevice == RecognizedDevice.UNKNOWN_SPARK) {
                if ((message.messageId() & 0x1FFFFFC0) != 33929216) continue;
                bus = this.canBridge.getBusOrNull(descriptor);
                recognizedDevice = Detector.getSparkModel(this.canBridge, bus, message, deviceId);
            }
            if (recognizedDevice == RecognizedDevice.UNKNOWN_ENCODER) {
                if ((message.messageId() & 0x1FFFFFC0) != 117815296) continue;
                bus = this.canBridge.getBusOrNull(descriptor);
                recognizedDevice = Detector.getEncoderModel(this.canBridge, bus, message, deviceId);
            }
            if (recognizedDevice == RecognizedDevice.SERVO_HUB) {
                if ((message.messageId() & 0x1FFFFFC0) == 201701376) {
                    isBootloader = false;
                } else {
                    if ((message.messageId() & 0x1FFFFFC0) != 201699328) continue;
                    isBootloader = true;
                }
            }
            if (recognizedDevice == RecognizedDevice.PDH) {
                if ((message.messageId() & 0x1FFFFFC0) == 134551552) {
                    isBootloader = false;
                } else {
                    if ((message.messageId() & 0x1FFFFFC0) != 134590464) continue;
                    isBootloader = true;
                }
            }
            if (recognizedDevice == RecognizedDevice.PH) {
                if ((message.messageId() & 0x1FFFFFC0) == 151328768) {
                    isBootloader = false;
                } else {
                    if ((message.messageId() & 0x1FFFFFC0) != 151367680) continue;
                    isBootloader = true;
                }
            }
            FRCCanDevice device = new FRCCanDevice(descriptor, deviceId, isBootloader, recognizedDevice, Detector.deviceUUID(deviceId, deviceType, manufacturer));
            if (!canDevices.stream().noneMatch(device::frcEquals)) continue;
            canDevices.add(device);
        }
        return canDevices;
    }

    private static RecognizedDevice getSparkModel(CanBridge bridge, CanBus bus, CanMessage message, int canId) {
        SparkAdvanced.SparkModel model = SparkAdvanced.getModel((CanMessage)message);
        if (model == SparkAdvanced.SparkModel.SPARK_MAX) {
            return RecognizedDevice.SPARK_MAX;
        }
        if (model == SparkAdvanced.SparkModel.SPARK_FLEX) {
            return RecognizedDevice.SPARK_FLEX;
        }
        if (model == SparkAdvanced.SparkModel.UNKNOWN) {
            SparkAdvanced.SparkFirmwareVersion version = SparkAdvanced.getFirmwareVersion((CanBridge)bridge, (CanBus)bus, (int)canId);
            if (version == null) {
                return RecognizedDevice.UNKNOWN_SPARK;
            }
            int versionParameter = SparkAdvanced.readParameterInt32((CanBridge)bridge, (CanBus)bus, (int)canId, (int)SparkParameters.kProductId.value);
            return RecognizedDevice.getSparkTypeFromProductId(versionParameter);
        }
        return RecognizedDevice.UNKNOWN_SPARK;
    }

    private static RecognizedDevice getEncoderModel(CanBridge bridge, CanBus bus, CanMessage message, int canId) {
        EncoderAdvanced.EncoderModel model = EncoderAdvanced.getEncoderModel((CanMessage)message);
        return switch (model) {
            default -> throw new MatchException(null, null);
            case EncoderAdvanced.EncoderModel.MAXSPLINE -> RecognizedDevice.MAXSPLINE_ENCODER;
            case EncoderAdvanced.EncoderModel.UNKNOWN -> RecognizedDevice.UNKNOWN_ENCODER;
        };
    }

    public CanBridgeCallback addCanBridgeCallback(CanBridgeCallback callback) {
        return this.canBridge.addCallback(callback);
    }

    public void removeCanBridgeCallback(CanBridgeCallback callback) {
        this.canBridge.removeCallback(callback);
    }

    public ScanCallback addScanCallback(DetectorStage stage, ScanCallback scanCallback) {
        this.scanCallbacks.add(new StagedCallback(stage, scanCallback));
        this.scanCallbacks.sort(Comparator.comparingInt(stagedValue -> stagedValue.stage.index));
        scanCallback.onNewScanResult(List.copyOf(this.detectedDevices), List.copyOf(this.detectedDevices), Collections.emptyList(), Collections.emptyList());
        return scanCallback;
    }

    public void addDfuUpdatingDevice(DfuDevice device) {
        this.dfuUpdatingDevices.add(device);
    }

    public void removeDfuUpdatingDevice(DfuDevice device) {
        this.dfuUpdatingDevices.remove(device);
    }

    public void close() {
        this.scanCallbacks.clear();
        this.detectedDevices.clear();
    }

    public void removeCallback(ScanCallback callback) {
        this.scanCallbacks.removeIf(stagedCallback -> stagedCallback.callback == callback);
    }

    public static enum DetectorStage {
        DEVICES_DETECTED(0),
        INITIALIZING(1),
        FULLY_INITIALIZED(2);

        final int index;

        private DetectorStage(int index) {
            this.index = index;
        }
    }

    public static interface ScanCallback {
        public void onNewScanResult(List<DeviceTree> var1, List<DeviceTree> var2, List<DeviceTree> var3, List<DeviceTree> var4);
    }

    private record StagedCallback(DetectorStage stage, ScanCallback callback) {
    }
}

