/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.MappingException;
import org.hibernate.boot.model.relational.Exportable;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;

public abstract class Constraint
implements Exportable,
Serializable {
    private String name;
    private final ArrayList<Column> columns = new ArrayList();
    private Table table;
    private String options = "";

    Constraint() {
    }

    Constraint(Table table) {
        this.table = table;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOptions() {
        return this.options;
    }

    public void setOptions(String options) {
        this.options = options;
    }

    public void addColumn(Column column) {
        if (!this.columns.contains(column)) {
            this.columns.add(column);
        }
    }

    public void addColumns(Value value) {
        for (Selectable selectable : value.getSelectables()) {
            if (selectable.isFormula()) {
                throw new MappingException("constraint involves a formula: " + this.name);
            }
            this.addColumn((Column)selectable);
        }
    }

    public boolean containsColumn(Column column) {
        return this.columns.contains(column);
    }

    public int getColumnSpan() {
        return this.columns.size();
    }

    public Column getColumn(int i) {
        return this.columns.get(i);
    }

    public Table getTable() {
        return this.table;
    }

    @Deprecated(since="7")
    public void setTable(Table table) {
        this.table = table;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getTable().getName() + String.valueOf(this.getColumns()) + ") as " + this.name;
    }
}

