/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.json;

import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.json.AbstractJsonParser;
import tools.jackson.core.type.TypeReference;
import tools.jackson.databind.json.JsonMapper;

public class JacksonJsonParser
extends AbstractJsonParser {
    private static final MapTypeReference MAP_TYPE = new MapTypeReference();
    private static final ListTypeReference LIST_TYPE = new ListTypeReference();
    private @Nullable JsonMapper jsonMapper;

    public JacksonJsonParser(JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
    }

    public JacksonJsonParser() {
    }

    @Override
    public Map<String, Object> parseMap(@Nullable String json) {
        return this.tryParse(() -> (Map)this.getJsonMapper().readValue(json, (TypeReference)MAP_TYPE), Exception.class);
    }

    @Override
    public List<Object> parseList(@Nullable String json) {
        return this.tryParse(() -> (List)this.getJsonMapper().readValue(json, (TypeReference)LIST_TYPE), Exception.class);
    }

    private JsonMapper getJsonMapper() {
        if (this.jsonMapper == null) {
            this.jsonMapper = new JsonMapper();
        }
        return this.jsonMapper;
    }

    private static final class ListTypeReference
    extends TypeReference<List<Object>> {
        private ListTypeReference() {
        }
    }

    private static final class MapTypeReference
    extends TypeReference<Map<String, Object>> {
        private MapTypeReference() {
        }
    }
}

