/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.egl.gbm;

import com.jogamp.common.nio.Buffers;
import com.jogamp.nativewindow.AbstractGraphicsScreen;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.util.Point;
import com.jogamp.newt.Display;
import com.jogamp.opengl.GLCapabilitiesChooser;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.egl.EGL;
import java.nio.ByteBuffer;
import jogamp.nativewindow.drm.DRMLib;
import jogamp.nativewindow.drm.DRMUtil;
import jogamp.nativewindow.drm.DrmMode;
import jogamp.nativewindow.drm.drmModeModeInfo;
import jogamp.newt.PointerIconImpl;
import jogamp.newt.WindowImpl;
import jogamp.newt.driver.KeyTracker;
import jogamp.newt.driver.MouseTracker;
import jogamp.newt.driver.egl.gbm.DisplayDriver;
import jogamp.newt.driver.egl.gbm.ScreenDriver;
import jogamp.newt.driver.linux.LinuxKeyEventTracker;
import jogamp.newt.driver.linux.LinuxMouseTracker;
import jogamp.opengl.egl.EGLGraphicsConfiguration;
import jogamp.opengl.egl.EGLGraphicsConfigurationFactory;
import jogamp.opengl.egl.EGLSurface;

public class WindowDriver
extends WindowImpl {
    private final MouseTracker mouseTracker = LinuxMouseTracker.getSingleton();
    private final KeyTracker keyTracker = LinuxKeyEventTracker.getSingleton();
    private long windowHandleClose = 0L;
    private long eglSurface;
    private long lastBO;

    private void zeroPosition(ScreenDriver screenDriver, int n, int n2) {
        boolean bl = false;
        if (0 != n) {
            n = 0;
            bl = true;
        }
        if (0 != n2) {
            n2 = 0;
            bl = true;
        }
        if (bl) {
            this.defineWindowPosition(n, n2);
        }
    }

    private void adjustSize(ScreenDriver screenDriver, int n, int n2) {
        int n3 = screenDriver.getWidth();
        int n4 = screenDriver.getHeight();
        boolean bl = false;
        if (n3 != n) {
            n = n3;
            bl = true;
        }
        if (n4 != n2) {
            n2 = n4;
            bl = true;
        }
        if (bl) {
            this.defineWindowSize(n, n2);
        }
    }

    @Override
    protected boolean canCreateNativeImpl() {
        this.zeroPosition((ScreenDriver)this.getScreen(), this.getX(), this.getY());
        this.adjustSize((ScreenDriver)this.getScreen(), this.getWidth(), this.getHeight());
        return true;
    }

    @Override
    protected void createNativeImpl(boolean[] blArray) {
        int n;
        if (0L != this.getParentWindowHandle()) {
            throw new RuntimeException("Window parenting not supported (yet)");
        }
        ScreenDriver screenDriver = (ScreenDriver)this.getScreen();
        DisplayDriver displayDriver = (DisplayDriver)screenDriver.getDisplay();
        AbstractGraphicsScreen abstractGraphicsScreen = screenDriver.getGraphicsScreen();
        int n2 = n = this.capsRequested.isBackgroundOpaque() ? DRMUtil.GBM_FORMAT_XRGB8888 : DRMUtil.GBM_FORMAT_ARGB8888;
        if (!EGL.eglBindAPI(12448)) {
            throw new GLException("Caught: eglBindAPI to GL failed , error " + WindowDriver.toHexString(EGL.eglGetError()));
        }
        GLCapabilitiesImmutable gLCapabilitiesImmutable = EGLGraphicsConfigurationFactory.castOrCopyImmutable(this.capsRequested);
        EGLGraphicsConfiguration eGLGraphicsConfiguration = EGLGraphicsConfigurationFactory.chooseGraphicsConfigurationStatic(gLCapabilitiesImmutable, gLCapabilitiesImmutable, (GLCapabilitiesChooser)this.capabilitiesChooser, abstractGraphicsScreen, n, !this.capsRequested.isBackgroundOpaque());
        if (eGLGraphicsConfiguration == null) {
            throw new NativeWindowException("Error choosing GraphicsConfiguration creating window: " + this);
        }
        this.setGraphicsConfiguration(eGLGraphicsConfiguration);
        long l = DRMLib.gbm_surface_create(displayDriver.getGBMHandle(), this.getWidth(), this.getHeight(), n, 5);
        if (l == 0L) {
            throw new NativeWindowException("Error creating egl window: " + eGLGraphicsConfiguration);
        }
        this.setWindowHandle(l);
        if (0L == this.getWindowHandle()) {
            throw new NativeWindowException("Error native Window Handle is null");
        }
        this.windowHandleClose = l;
        this.eglSurface = EGLSurface.eglCreateWindowSurface(displayDriver.getHandle(), eGLGraphicsConfiguration.getNativeConfig(), l);
        if (0L == this.eglSurface) {
            throw new NativeWindowException("Creation of eglSurface failed: " + eGLGraphicsConfiguration + ", windowHandle 0x" + Long.toHexString(l) + ", error " + WindowDriver.toHexString(EGL.eglGetError()));
        }
        this.lastBO = 0L;
        if (null != this.keyTracker) {
            this.addWindowListener(this.keyTracker);
        }
        if (null != this.mouseTracker) {
            this.addWindowListener(this.mouseTracker);
        }
        this.visibleChanged(true);
        this.focusChanged(false, true);
    }

    @Override
    protected void closeNativeImpl() {
        Display display = this.getScreen().getDisplay();
        if (null != this.mouseTracker) {
            this.removeWindowListener(this.mouseTracker);
        }
        if (null != this.keyTracker) {
            this.removeWindowListener(this.keyTracker);
        }
        this.lastBO = 0L;
        if (0L != this.eglSurface) {
            try {
                if (!EGL.eglDestroySurface(display.getHandle(), this.eglSurface)) {
                    throw new GLException("Error destroying window surface (eglDestroySurface)");
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            finally {
                this.eglSurface = 0L;
            }
        }
        if (0L != this.windowHandleClose) {
            DRMLib.gbm_surface_destroy(this.windowHandleClose);
            this.windowHandleClose = 0L;
        }
    }

    @Override
    public final long getSurfaceHandle() {
        return this.eglSurface;
    }

    @Override
    public boolean surfaceSwap() {
        ScreenDriver screenDriver = (ScreenDriver)this.getScreen();
        DisplayDriver displayDriver = (DisplayDriver)screenDriver.getDisplay();
        long l = this.getWindowHandle();
        DrmMode drmMode = screenDriver.drmMode;
        GLContext gLContext = GLContext.getCurrent();
        int n = gLContext.getSwapInterval();
        gLContext.getGL().glFinish();
        if (!EGL.eglSwapBuffers(displayDriver.getHandle(), this.eglSurface)) {
            throw new GLException("Error swapping buffers, eglError " + WindowDriver.toHexString(EGL.eglGetError()) + ", " + this);
        }
        this.lastBO = 0L == this.lastBO ? this.FirstSwapSurface(drmMode.drmFd, drmMode.getCrtcIDs()[0], 0, 0, drmMode.getConnectors()[0].getConnector_id(), drmMode.getModes()[0], l) : this.NextSwapSurface(drmMode.drmFd, drmMode.getCrtcIDs()[0], drmMode.getConnectors()[0].getConnector_id(), drmMode.getModes()[0], l, this.lastBO, n);
        return true;
    }

    @Override
    protected void requestFocusImpl(boolean bl) {
        this.focusChanged(false, true);
    }

    @Override
    protected final int getSupportedReconfigMaskImpl() {
        return 12297;
    }

    @Override
    protected boolean reconfigureWindowImpl(int n, int n2, int n3, int n4, int n5) {
        return false;
    }

    @Override
    protected Point getLocationOnScreenImpl(int n, int n2) {
        return new Point(n, n2);
    }

    @Override
    protected final void doMouseEvent(boolean bl, boolean bl2, short s, int n, int n2, int n3, short s2, float[] fArray, float f) {
        if (205 == s || 206 == s) {
            ScreenDriver screenDriver = (ScreenDriver)this.getScreen();
            screenDriver.moveActivePointerIcon(this.getX() + n2, this.getY() + n3);
        }
        super.doMouseEvent(bl, bl2, s, n, n2, n3, s2, fArray, f);
    }

    @Override
    protected void setPointerIconImpl(PointerIconImpl pointerIconImpl) {
        ScreenDriver screenDriver = (ScreenDriver)this.getScreen();
        if (null != this.mouseTracker) {
            screenDriver.setPointerIconActive(pointerIconImpl, this.mouseTracker.getLastX(), this.mouseTracker.getLastY());
        } else {
            screenDriver.setPointerIconActive(pointerIconImpl, 0, 0);
        }
    }

    @Override
    protected boolean setPointerVisibleImpl(boolean bl) {
        ScreenDriver screenDriver = (ScreenDriver)this.getScreen();
        if (null != this.mouseTracker) {
            screenDriver.setActivePointerIconVisible(bl, this.mouseTracker.getLastX(), this.mouseTracker.getLastY());
        } else {
            screenDriver.setActivePointerIconVisible(bl, 0, 0);
        }
        return true;
    }

    protected static native boolean initIDs();

    private long FirstSwapSurface(int n, int n2, int n3, int n4, int n5, drmModeModeInfo drmModeModeInfo2, long l) {
        ByteBuffer byteBuffer = drmModeModeInfo2.getBuffer();
        if (!Buffers.isDirect((Object)byteBuffer)) {
            throw new IllegalArgumentException("drmMode's buffer is not direct (NIO)");
        }
        return this.FirstSwapSurface0(n, n2, n3, n4, n5, byteBuffer, Buffers.getDirectBufferByteOffset((Object)byteBuffer), l);
    }

    private native long FirstSwapSurface0(int var1, int var2, int var3, int var4, int var5, Object var6, int var7, long var8);

    private long NextSwapSurface(int n, int n2, int n3, drmModeModeInfo drmModeModeInfo2, long l, long l2, int n4) {
        ByteBuffer byteBuffer = drmModeModeInfo2.getBuffer();
        if (!Buffers.isDirect((Object)byteBuffer)) {
            throw new IllegalArgumentException("drmMode's buffer is not direct (NIO)");
        }
        return this.NextSwapSurface0(n, n2, n3, byteBuffer, Buffers.getDirectBufferByteOffset((Object)byteBuffer), l, l2, n4);
    }

    private native long NextSwapSurface0(int var1, int var2, int var3, Object var4, int var5, long var6, long var8, int var10);

    static {
        DisplayDriver.initSingleton();
    }
}

