"use strict";(self.webpackChunkadvantagescope_docs=self.webpackChunkadvantagescope_docs||[]).push([[7086],{3679:(e,t,n)=>{n.r(t),n.d(t,{assets:()=>d,contentTitle:()=>i,default:()=>h,frontMatter:()=>a,metadata:()=>s,toc:()=>c});const s=JSON.parse('{"id":"overview/legacy-formats","title":"\u26a0\ufe0f Legacy Format Deprecation","description":"WPILib supports the type-safe and unit-safe struct format for publishing complex data types such as geometry objects, swerve states, and more! AdvantageScope takes advantage of the struct format to streamline the process of configuring fields for visualization. For example, 2D and 3D poses can now be used side-by-side on the \ud83d\uddfa 2D Field and \ud83d\udc40 3D Field tabs with no manual configuration and no unit errors.","source":"@site/docs/overview/legacy-formats.md","sourceDirName":"overview","slug":"/overview/legacy-formats","permalink":"/overview/legacy-formats","draft":false,"unlisted":false,"tags":[],"version":"current","sidebarPosition":6,"frontMatter":{"sidebar_position":6},"sidebar":"sidebar","previous":{"title":"\ud83d\udcfd\ufe0f Championship Conference","permalink":"/overview/champs-conference"},"next":{"title":"Tab Reference","permalink":"/category/tab-reference"}}');var o=n(4848),r=n(8453);const a={sidebar_position:6},i="\u26a0\ufe0f Legacy Format Deprecation",d={},c=[{value:"What&#39;s Changing?",id:"whats-changing",level:2},{value:"How Do I Update?",id:"how-do-i-update",level:2}];function l(e){const t={a:"a",admonition:"admonition",code:"code",h1:"h1",h2:"h2",header:"header",p:"p",pre:"pre",strong:"strong",table:"table",tbody:"tbody",td:"td",th:"th",thead:"thead",tr:"tr",...(0,r.R)(),...e.components},{Details:n}=t;return n||function(e,t){throw new Error("Expected "+(t?"component":"object")+" `"+e+"` to be defined: you likely forgot to import, pass, or provide it.")}("Details",!0),(0,o.jsxs)(o.Fragment,{children:[(0,o.jsx)(t.header,{children:(0,o.jsx)(t.h1,{id:"\ufe0f-legacy-format-deprecation",children:"\u26a0\ufe0f Legacy Format Deprecation"})}),"\n",(0,o.jsxs)(t.p,{children:["WPILib supports the type-safe and unit-safe ",(0,o.jsx)(t.strong,{children:"struct format"})," for publishing complex data types such as geometry objects, swerve states, and more! AdvantageScope takes advantage of the struct format to streamline the process of configuring fields for visualization. For example, 2D and 3D poses can now be used side-by-side on the ",(0,o.jsx)(t.a,{href:"/tab-reference/2d-field",children:"\ud83d\uddfa 2D Field"})," and ",(0,o.jsx)(t.a,{href:"/tab-reference/3d-field",children:"\ud83d\udc40 3D Field"})," tabs with ",(0,o.jsx)(t.strong,{children:"no manual configuration"})," and ",(0,o.jsx)(t.strong,{children:"no unit errors"}),"."]}),"\n",(0,o.jsxs)(t.p,{children:['Before 2025, AdvantageScope supported both structs and the legacy "number array" format for geometry types. The legacy format packed structured data into a format like ',(0,o.jsx)(t.code,{children:"double[]"})," (e.g. a pose would be represented by the array ",(0,o.jsx)(t.code,{children:"[x, y, rotation]"}),")."]}),"\n",(0,o.jsx)(t.admonition,{type:"info",children:(0,o.jsxs)(t.p,{children:["For more information on the design of structs and their advantages, check out ",(0,o.jsx)(t.a,{href:"https://www.chiefdelphi.com/t/introducing-monologue-annotation-based-telemetry-and-data-logging-for-java-teams/443917/5",children:"this post"}),"."]})}),"\n",(0,o.jsx)(t.h2,{id:"whats-changing",children:"What's Changing?"}),"\n",(0,o.jsxs)(t.p,{children:["In 2025 and 2026, AdvantageScope continues to support both the modern struct format and the legacy number array format. However, ",(0,o.jsxs)(t.strong,{children:["the legacy number array format is now ",(0,o.jsx)("u",{children:"deprecated"})," and will be removed in 2027"]}),". AdvantageScope will present a warning when the legacy format is used, and additional information must be manually provided to specify the packing format and units."]}),"\n",(0,o.jsxs)(t.table,{children:[(0,o.jsx)(t.thead,{children:(0,o.jsxs)(t.tr,{children:[(0,o.jsx)(t.th,{}),(0,o.jsx)(t.th,{children:"Modern Struct Format"}),(0,o.jsx)(t.th,{children:"Legacy Number Array Format"})]})}),(0,o.jsxs)(t.tbody,{children:[(0,o.jsxs)(t.tr,{children:[(0,o.jsxs)(t.td,{children:[(0,o.jsx)(t.strong,{children:"2024"})," (v3.x)"]}),(0,o.jsx)(t.td,{children:"\u2705 Recommended"}),(0,o.jsx)(t.td,{children:"\u2705 Supported"})]}),(0,o.jsxs)(t.tr,{children:[(0,o.jsxs)(t.td,{children:[(0,o.jsx)(t.strong,{children:"2025"})," (v4.x)"]}),(0,o.jsx)(t.td,{children:"\u2705 Recommended"}),(0,o.jsx)(t.td,{children:"\u26a0\ufe0f Deprecated"})]}),(0,o.jsxs)(t.tr,{children:[(0,o.jsxs)(t.td,{children:[(0,o.jsx)(t.strong,{children:"2026"})," (v26.x)"]}),(0,o.jsx)(t.td,{children:"\u2705 Recommended"}),(0,o.jsx)(t.td,{children:"\u26a0\ufe0f Deprecated"})]}),(0,o.jsxs)(t.tr,{children:[(0,o.jsxs)(t.td,{children:[(0,o.jsx)(t.strong,{children:"2027"})," (v27.x)"]}),(0,o.jsx)(t.td,{children:"\u2705 Recommended"}),(0,o.jsx)(t.td,{children:"\u274c Removed"})]})]})]}),"\n",(0,o.jsx)(t.admonition,{type:"warning",children:(0,o.jsx)(t.p,{children:"While the legacy format can still be used, additional information must be provided about the packing format and units of each field. After adding an array field to a tab, the format can be configured by clicking the icon to the left of the field name."})}),"\n",(0,o.jsx)(t.h2,{id:"how-do-i-update",children:"How Do I Update?"}),"\n",(0,o.jsxs)(t.p,{children:["Most major tools and libraries already support the modern struct format (check the documentation of each library for details). Below, you can see how to upgrade to the modern format for several common libraries. The struct format supports both single objects and object arrays (such as ",(0,o.jsx)(t.code,{children:"Pose2d[]"}),")."]}),"\n",(0,o.jsx)(t.admonition,{type:"tip",children:(0,o.jsx)(t.p,{children:"If you rely on a library that hasn't upgraded to the new format, reach out the developers for details."})}),"\n",(0,o.jsxs)(n,{children:[(0,o.jsx)("summary",{children:"NetworkTables"}),(0,o.jsxs)(t.p,{children:["To publish struct data to NetworkTables, create a ",(0,o.jsx)(t.code,{children:"StructPublisher"})," with the desired type and call ",(0,o.jsx)(t.code,{children:"set()"})," as shown below."]}),(0,o.jsx)(t.pre,{children:(0,o.jsx)(t.code,{className:"language-java",children:'StructPublisher<Pose2d> publisher = NetworkTableInstance.getDefault()\n  .getStructTopic("MyPose", Pose2d.struct).publish();\npublisher.set(new Pose2d());\n'})}),(0,o.jsx)(t.admonition,{type:"tip",children:(0,o.jsxs)(t.p,{children:["WPILib will support a struct alternative to the ",(0,o.jsx)(t.a,{href:"https://github.wpilib.org/allwpilib/docs/release/java/edu/wpi/first/wpilibj/smartdashboard/SmartDashboard.html",children:(0,o.jsx)(t.code,{children:"SmartDashboard"})})," style ",(0,o.jsx)(t.code,{children:"put"})," methods in 2027. In the meantime, consider using another logging library such as Monologue that supports an imperative API."]})})]}),"\n",(0,o.jsxs)(n,{children:[(0,o.jsx)("summary",{children:"Field2d"}),(0,o.jsxs)(t.p,{children:["WPILib's ",(0,o.jsx)(t.code,{children:"Field2d"})," class does not support the modern struct format, but will be superseded by an improved telemetry API in 2027. In the meantime, users who wish to try the modern format can publish pose data using the NetworkTables API shown above."]})]}),"\n",(0,o.jsxs)(n,{children:[(0,o.jsx)("summary",{children:"Epilogue"}),(0,o.jsx)(t.p,{children:"To publish struct data using Epilogue, simply return a supported object type from a logged method:"}),(0,o.jsx)(t.pre,{children:(0,o.jsx)(t.code,{className:"language-java",children:"@Logged\npublic class MyClass {\n  public Pose2d getPose() {\n    return new Pose2d();\n  }\n}\n"})})]}),"\n",(0,o.jsxs)(n,{children:[(0,o.jsx)("summary",{children:"Monologue"}),(0,o.jsxs)(t.p,{children:["To publish struct data using Monologue, simply return a supported object type from a method tagged with ",(0,o.jsx)(t.code,{children:"@Log"}),":"]}),(0,o.jsx)(t.pre,{children:(0,o.jsx)(t.code,{className:"language-java",children:"@Log\npublic Pose2d getPose() {\n  return new Pose2d();\n}\n"})}),(0,o.jsx)(t.p,{children:"Objects can also be logged imperatively:"}),(0,o.jsx)(t.pre,{children:(0,o.jsx)(t.code,{className:"language-java",children:'log("MyPose", new Pose2d());\n'})})]}),"\n",(0,o.jsxs)(n,{children:[(0,o.jsx)("summary",{children:"AdvantageKit"}),(0,o.jsxs)(t.p,{children:["To log and replay struct data using AdvantageKit, simply pass a supported object type to the ",(0,o.jsx)(t.code,{children:"recordOutput"})," method, return it from a method/field tagged with ",(0,o.jsx)(t.code,{children:"@AutoLogOutput"}),", or include it in an inputs class tagged with ",(0,o.jsx)(t.code,{children:"@AutoLog"}),"."]}),(0,o.jsx)(t.pre,{children:(0,o.jsx)(t.code,{className:"language-java",children:'// Standard output logging\nLogger.recordOutput("MyPose", new Pose2d());\n\n// Annotation output logging\npublic class MyClass {\n  @AutoLogOutput\n  public Pose2d getPose() {\n    return new Pose2d();\n  }\n\n  @AutoLogOutput\n  public Pose2d myPose = new Pose2d();\n}\n\n// Inputs class\n@AutoLog\npublic class Inputs {\n  public Pose2d myPose = new Pose2d();\n}\n'})})]}),"\n",(0,o.jsxs)(n,{children:[(0,o.jsx)("summary",{children:"DataLog"}),(0,o.jsxs)(t.p,{children:["To append struct data to a raw ",(0,o.jsx)(t.code,{children:"DataLog"}),", create a ",(0,o.jsx)(t.code,{children:"StructLogEntry"})," with the desired type and call ",(0,o.jsx)(t.code,{children:"set()"})," as shown below."]}),(0,o.jsx)(t.pre,{children:(0,o.jsx)(t.code,{className:"language-java",children:'StructLogEntry<Pose2d> logEntry =\n        StructLogEntry.create(DataLogManager.getLog(), "MyPose", Pose2d.struct);\nlogEntry.append(new Pose2d());\n'})})]}),"\n",(0,o.jsxs)(n,{children:[(0,o.jsx)("summary",{children:"Phoenix Signal Logger (Hoot)"}),(0,o.jsx)(t.p,{children:"The Phoenix signal logger does not support the modern struct format. Consider publishing geometry data using one of the logging libraries shown above instead of using custom signals in Phoenix."}),(0,o.jsx)(t.admonition,{type:"tip",children:(0,o.jsxs)(t.p,{children:["AdvantageScope can automatically merge log files from multiple sources, such as Hoot and WPILOG files. See ",(0,o.jsx)(t.a,{href:"/overview/log-files",children:"here"})," for details."]})})]})]})}function h(e={}){const{wrapper:t}={...(0,r.R)(),...e.components};return t?(0,o.jsx)(t,{...e,children:(0,o.jsx)(l,{...e})}):l(e)}},8453:(e,t,n)=>{n.d(t,{R:()=>a,x:()=>i});var s=n(6540);const o={},r=s.createContext(o);function a(e){const t=s.useContext(r);return s.useMemo((function(){return"function"==typeof e?e(t):{...t,...e}}),[t,e])}function i(e){let t;return t=e.disableParentContext?"function"==typeof e.components?e.components(o):e.components||o:a(e.components),s.createElement(r.Provider,{value:t},e.children)}}}]);