/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.device.detection;

import com.revrobotics.canbridge.CanBridge;
import com.revrobotics.canbridge.CanBus;
import com.revrobotics.canbridge.CanMessage;
import java.util.HashMap;
import java.util.Map;

public class HeartbeatSender {
    private static final int SECONDARY_HEARTBEAT_ID = 33893504;
    private static final int REV_UNIVERSAL_SECONDARY_HEARTBEAT_ID = 328384;
    private static final int SECONDARY_HEARTBEAT_INTERVAL = 25;
    private final CanBridge bridge;
    private final Map<CanBus, byte[]> heartbeatMap = new HashMap<CanBus, byte[]>();

    public HeartbeatSender(CanBridge bridge) {
        this.bridge = bridge;
    }

    public void enableSpark(CanBus bus, int id) {
        int index;
        byte[] heartbeatData = this.heartbeatMap.get(bus);
        if (heartbeatData == null) {
            return;
        }
        int n = index = id / 8;
        heartbeatData[n] = (byte)(heartbeatData[n] | (byte)(1 << id % 8));
        this.updateHeartbeat(bus);
    }

    public void disableSpark(CanBus bus, int id) {
        int index;
        byte[] heartbeatData = this.heartbeatMap.get(bus);
        if (heartbeatData == null) {
            return;
        }
        int n = index = id / 8;
        heartbeatData[n] = (byte)(heartbeatData[n] & (byte)(~(1 << id % 8)));
        this.updateHeartbeat(bus);
    }

    void addDevice(CanBus bus) {
        this.heartbeatMap.put(bus, new byte[8]);
        this.updateHeartbeat(bus);
    }

    void updateHeartbeat(CanBus bus) {
        CanMessage heartbeatMessage = CanMessage.createClassic((int)33893504, (byte[])this.heartbeatMap.get(bus));
        this.bridge.sendMessage(bus, heartbeatMessage, 25);
        CanMessage revUniversalSecondaryHeartbeatMessage = CanMessage.createClassic((int)328384, (byte[])new byte[]{1});
        this.bridge.sendMessage(bus, revUniversalSecondaryHeartbeatMessage, 25);
    }

    void removeDevice(CanBus bus) {
        this.heartbeatMap.remove(bus);
        this.bridge.stopMessage(bus, CanMessage.createClassic((int)33893504, (byte[])new byte[8]));
    }
}

