/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.servohub;

import com.revrobotics.servohub.ServoHub;
import com.revrobotics.sim.ServoHubSimFaultManager;
import edu.wpi.first.hal.SimDouble;
import edu.wpi.first.hal.SimInt;
import edu.wpi.first.wpilibj.simulation.SimDeviceSim;

public class ServoHubSim {
    private final SimDouble m_deviceVoltage;
    private final SimDouble m_deviceCurrent;
    private final SimDouble m_servoVoltage;
    private final SimInt[] m_bankPulsePeriods = new SimInt[2];
    private final ServoHub m_servoHub;
    private String m_deviceName;
    private Boolean m_enable = null;

    public ServoHubSim(ServoHub servoHub) {
        this.m_deviceName = "Servo Hub [" + servoHub.getDeviceId() + "]";
        SimDeviceSim servoHubSim = new SimDeviceSim(this.m_deviceName);
        this.m_deviceVoltage = servoHubSim.getDouble("Device Voltage");
        this.m_deviceCurrent = servoHubSim.getDouble("Device Current");
        this.m_servoVoltage = servoHubSim.getDouble("Servo Voltage");
        this.m_bankPulsePeriods[0] = servoHubSim.getInt("Bank 0-2 Pulse Period");
        this.m_bankPulsePeriods[1] = servoHubSim.getInt("Bank 3-5 Pulse Period");
        this.m_servoHub = servoHub;
    }

    public double getDeviceVoltage() {
        return this.m_deviceVoltage.get();
    }

    public void setDeviceVoltage(double voltage) {
        this.m_deviceVoltage.set(voltage);
    }

    public double getDeviceCurrent() {
        return this.m_deviceCurrent.get();
    }

    public void setDeviceCurrent(double current) {
        this.m_deviceCurrent.set(current);
    }

    public double getServoVoltage() {
        return this.m_servoVoltage.get();
    }

    public void setServoVoltage(double voltage) {
        this.m_servoVoltage.set(voltage);
    }

    public double getBankPulsePeriod(ServoHub.Bank bank) {
        return this.m_bankPulsePeriods[bank.value].get();
    }

    public void setBankPulsePeriod(ServoHub.Bank bank, int pulsePeriod_us) {
        this.m_bankPulsePeriods[bank.value].set(pulsePeriod_us);
    }

    public void enable() {
        this.m_enable = true;
    }

    public void disable() {
        this.m_enable = false;
    }

    public void useDriverStationEnable() {
        this.m_enable = null;
    }

    public ServoHubSimFaultManager getFaultManager() {
        return new ServoHubSimFaultManager(this.m_servoHub);
    }
}

