/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.spark;

import com.revrobotics.jni.CANSparkJNI;
import com.revrobotics.spark.SparkBase;

public class SparkLimitSwitch {
    private final SparkBase m_device;
    private final Direction m_limitSwitch;

    SparkLimitSwitch(SparkBase device, Direction direction) {
        this.m_device = device;
        this.m_limitSwitch = direction;
        if (direction == null) {
            throw new IllegalArgumentException("limitSwitch must not be null");
        }
        if (direction == Direction.kForward) {
            CANSparkJNI.c_Spark_CreateForwardLimitSwitchSim(device.sparkHandle);
        } else {
            CANSparkJNI.c_Spark_CreateReverseLimitSwitchSim(device.sparkHandle);
        }
    }

    public boolean isPressed() {
        this.m_device.throwIfClosed();
        return CANSparkJNI.c_Spark_GetLimitSwitch(this.m_device.sparkHandle, this.m_limitSwitch.value);
    }

    static enum Direction {
        kForward(0),
        kReverse(1);

        public final int value;

        private Direction(int value) {
            this.value = value;
        }

        public static Direction fromId(int id) {
            switch (id) {
                case 1: {
                    return kReverse;
                }
            }
            return kForward;
        }
    }
}

