/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.spark;

import com.revrobotics.jni.CANSparkJNI;
import com.revrobotics.spark.SparkBase;

public class SparkSoftLimit {
    private final SparkBase m_device;
    private final SoftLimitDirection m_softLimitDirection;

    SparkSoftLimit(SparkBase device, SoftLimitDirection direction) {
        this.m_device = device;
        this.m_softLimitDirection = direction;
        if (direction == null) {
            throw new IllegalArgumentException("soft limit must not be null");
        }
    }

    public boolean isReached() {
        this.m_device.throwIfClosed();
        return CANSparkJNI.c_Spark_GetSoftLimit(this.m_device.sparkHandle, this.m_softLimitDirection.value);
    }

    public static enum SoftLimitDirection {
        kForward(0),
        kReverse(1);

        public final int value;

        private SoftLimitDirection(int value) {
            this.value = value;
        }

        public static SoftLimitDirection fromId(int id) {
            switch (id) {
                case 1: {
                    return kReverse;
                }
            }
            return kForward;
        }
    }
}

