/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.spark.config;

import com.revrobotics.jni.CANSparkJNI;
import com.revrobotics.spark.ClosedLoopSlot;
import com.revrobotics.spark.FeedbackSensor;
import com.revrobotics.spark.config.FeedForwardConfigAccessor;
import com.revrobotics.spark.config.MAXMotionConfigAccessor;
import com.revrobotics.spark.config.SparkParameters;

public class ClosedLoopConfigAccessor {
    public final MAXMotionConfigAccessor maxMotion;
    public final FeedForwardConfigAccessor feedForward;
    private final long sparkHandle;

    protected ClosedLoopConfigAccessor(long sparkHandle) {
        this.sparkHandle = sparkHandle;
        this.maxMotion = new MAXMotionConfigAccessor(sparkHandle);
        this.feedForward = new FeedForwardConfigAccessor(sparkHandle);
    }

    public double getP() {
        return this.getP(ClosedLoopSlot.kSlot0);
    }

    public double getI() {
        return this.getI(ClosedLoopSlot.kSlot0);
    }

    public double getD() {
        return this.getD(ClosedLoopSlot.kSlot0);
    }

    @Deprecated(forRemoval=true)
    public double getFF() {
        return this.getFF(ClosedLoopSlot.kSlot0);
    }

    public double getDFilter() {
        return this.getDFilter(ClosedLoopSlot.kSlot0);
    }

    public double getIZone() {
        return this.getIZone(ClosedLoopSlot.kSlot0);
    }

    public double getMinOutput() {
        return this.getMinOutput(ClosedLoopSlot.kSlot0);
    }

    public double getMaxOutput() {
        return this.getMaxOutput(ClosedLoopSlot.kSlot0);
    }

    public double getP(ClosedLoopSlot slot) {
        return CANSparkJNI.c_Spark_GetParameterFloat32(this.sparkHandle, SparkParameters.kP_0.value + slot.value * 8);
    }

    public double getI(ClosedLoopSlot slot) {
        return CANSparkJNI.c_Spark_GetParameterFloat32(this.sparkHandle, SparkParameters.kI_0.value + slot.value * 8);
    }

    public double getD(ClosedLoopSlot slot) {
        return CANSparkJNI.c_Spark_GetParameterFloat32(this.sparkHandle, SparkParameters.kD_0.value + slot.value * 8);
    }

    @Deprecated(forRemoval=true)
    public double getFF(ClosedLoopSlot slot) {
        return CANSparkJNI.c_Spark_GetParameterFloat32(this.sparkHandle, SparkParameters.kV_0.value + slot.value * 8);
    }

    public double getDFilter(ClosedLoopSlot slot) {
        return CANSparkJNI.c_Spark_GetParameterFloat32(this.sparkHandle, SparkParameters.kDFilter_0.value + slot.value * 8);
    }

    public double getIZone(ClosedLoopSlot slot) {
        return CANSparkJNI.c_Spark_GetParameterFloat32(this.sparkHandle, SparkParameters.kIZone_0.value + slot.value * 8);
    }

    public double getMinOutput(ClosedLoopSlot slot) {
        return CANSparkJNI.c_Spark_GetParameterFloat32(this.sparkHandle, SparkParameters.kOutputMin_0.value + slot.value * 8);
    }

    public double getMaxOutput(ClosedLoopSlot slot) {
        return CANSparkJNI.c_Spark_GetParameterFloat32(this.sparkHandle, SparkParameters.kOutputMax_0.value + slot.value * 8);
    }

    public double getMaxIAccumulation() {
        return this.getMaxIAccumulation(ClosedLoopSlot.kSlot0);
    }

    public double getMaxIAccumulation(ClosedLoopSlot slot) {
        return CANSparkJNI.c_Spark_GetParameterFloat32(this.sparkHandle, SparkParameters.kIMaxAccum_0.value + slot.value * 4);
    }

    public double getAllowedClosedLoopError(ClosedLoopSlot slot) {
        return CANSparkJNI.c_Spark_GetParameterFloat32(this.sparkHandle, SparkParameters.kAllowedClosedLoopError_0.value + slot.value * 4);
    }

    public boolean getPositionWrappingEnabled() {
        return CANSparkJNI.c_Spark_GetParameterBool(this.sparkHandle, SparkParameters.kPositionPIDWrapEnable.value);
    }

    public double getPositionWrappingMinInput() {
        return CANSparkJNI.c_Spark_GetParameterFloat32(this.sparkHandle, SparkParameters.kPositionPIDMinInput.value);
    }

    public double getPositionWrappingMaxInput() {
        return CANSparkJNI.c_Spark_GetParameterFloat32(this.sparkHandle, SparkParameters.kPositionPIDMaxInput.value);
    }

    public FeedbackSensor getFeedbackSensor() {
        int value = CANSparkJNI.c_Spark_GetParameterUint32(this.sparkHandle, SparkParameters.kClosedLoopControlSensor.value);
        return FeedbackSensor.fromId(value);
    }
}

