/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.spark.config;

import com.revrobotics.config.BaseConfig;
import com.revrobotics.spark.ClosedLoopSlot;
import com.revrobotics.spark.config.SparkParameters;
import edu.wpi.first.wpilibj.DriverStation;

public class FeedForwardConfig
extends BaseConfig {
    private int kPIDSlotOffset;
    private int kFFSlotOffset;

    public FeedForwardConfig() {
        super(BaseConfig.CANType.kSpark);
        this.kPIDSlotOffset = SparkParameters.kP_1.value - SparkParameters.kP_0.value;
        this.kFFSlotOffset = SparkParameters.kS_1.value - SparkParameters.kS_0.value;
    }

    public FeedForwardConfig apply(FeedForwardConfig config) {
        super.apply(config);
        return this;
    }

    public FeedForwardConfig kS(double kS) {
        this.kS(kS, ClosedLoopSlot.kSlot0);
        return this;
    }

    public FeedForwardConfig kV(double kV) {
        this.kV(kV, ClosedLoopSlot.kSlot0);
        return this;
    }

    public FeedForwardConfig kA(double kA) {
        this.kA(kA, ClosedLoopSlot.kSlot0);
        return this;
    }

    public FeedForwardConfig kG(double kG) {
        this.kG(kG, ClosedLoopSlot.kSlot0);
        return this;
    }

    public FeedForwardConfig kCos(double kCos) {
        this.kCos(kCos, ClosedLoopSlot.kSlot0);
        return this;
    }

    public FeedForwardConfig kCosRatio(double kCosRatio) {
        this.kCosRatio(kCosRatio, ClosedLoopSlot.kSlot0);
        return this;
    }

    public FeedForwardConfig kS(double kS, ClosedLoopSlot slot) {
        this.putParameter(SparkParameters.kS_0.value + slot.value * this.kFFSlotOffset, (float)kS);
        return this;
    }

    public FeedForwardConfig kV(double kV, ClosedLoopSlot slot) {
        this.putParameter(SparkParameters.kV_0.value + slot.value * this.kPIDSlotOffset, (float)kV);
        return this;
    }

    public FeedForwardConfig kA(double kA, ClosedLoopSlot slot) {
        this.putParameter(SparkParameters.kA_0.value + slot.value * this.kFFSlotOffset, (float)kA);
        return this;
    }

    public FeedForwardConfig kG(double kG, ClosedLoopSlot slot) {
        if (this.getParameter(SparkParameters.kCos_0.value + slot.value * this.kFFSlotOffset) != null) {
            DriverStation.reportWarning((String)("kG is overriden by kCos, only kCos will be used on Closed Loop Slot " + slot.value), (boolean)true);
            return this;
        }
        this.putParameter(SparkParameters.kG_0.value + slot.value * this.kFFSlotOffset, (float)kG);
        return this;
    }

    public FeedForwardConfig kCos(double kCos, ClosedLoopSlot slot) {
        if (this.getParameter(SparkParameters.kG_0.value + slot.value * this.kFFSlotOffset) != null) {
            DriverStation.reportWarning((String)("kG is overriden by kCos, only kCos will be used on Closed Loop Slot " + slot.value), (boolean)true);
            this.removeParameter(SparkParameters.kG_0.value + slot.value * this.kFFSlotOffset);
        }
        this.putParameter(SparkParameters.kCos_0.value + slot.value * this.kFFSlotOffset, (float)kCos);
        return this;
    }

    public FeedForwardConfig kCosRatio(double kCosRatio, ClosedLoopSlot slot) {
        this.putParameter(SparkParameters.kCosRatio_0.value + slot.value * this.kFFSlotOffset, (float)kCosRatio);
        return this;
    }

    public FeedForwardConfig sv(double kS, double kV) {
        this.kS(kS);
        this.kV(kV);
        return this;
    }

    public FeedForwardConfig sva(double kS, double kV, double kA) {
        this.kS(kS);
        this.kV(kV);
        this.kA(kA);
        return this;
    }

    public FeedForwardConfig svag(double kS, double kV, double kA, double kG) {
        this.kS(kS);
        this.kV(kV);
        this.kA(kA);
        this.kG(kG);
        return this;
    }

    public FeedForwardConfig svacr(double kS, double kV, double kA, double kCos, double kCosRatio) {
        this.kS(kS);
        this.kV(kV);
        this.kA(kA);
        this.kCos(kCos);
        this.kCosRatio(kCosRatio);
        return this;
    }

    public FeedForwardConfig sg(double kS, double kG) {
        this.kS(kS);
        this.kG(kG);
        return this;
    }

    public FeedForwardConfig scr(double kS, double kCos, double kCosRatio) {
        this.kS(kS);
        this.kCos(kCos);
        this.kCosRatio(kCosRatio);
        return this;
    }

    public FeedForwardConfig sv(double kS, double kV, ClosedLoopSlot slot) {
        this.kS(kS, slot);
        this.kV(kV, slot);
        return this;
    }

    public FeedForwardConfig sva(double kS, double kV, double kA, ClosedLoopSlot slot) {
        this.kS(kS, slot);
        this.kV(kV, slot);
        this.kA(kA, slot);
        return this;
    }

    public FeedForwardConfig svag(double kS, double kV, double kA, double kG, ClosedLoopSlot slot) {
        this.kS(kS, slot);
        this.kV(kV, slot);
        this.kA(kA, slot);
        this.kG(kG, slot);
        return this;
    }

    public FeedForwardConfig svacr(double kS, double kV, double kA, double kCos, double kCosRatio, ClosedLoopSlot slot) {
        this.kS(kS, slot);
        this.kV(kV, slot);
        this.kA(kA, slot);
        this.kCos(kCos, slot);
        this.kCosRatio(kCosRatio, slot);
        return this;
    }

    public FeedForwardConfig sg(double kS, double kG, ClosedLoopSlot slot) {
        this.kS(kS, slot);
        this.kG(kG, slot);
        return this;
    }

    public FeedForwardConfig scr(double kS, double kCos, double kCosRatio, ClosedLoopSlot slot) {
        this.kS(kS, slot);
        this.kCos(kCos, slot);
        this.kCosRatio(kCosRatio, slot);
        return this;
    }
}

