/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.internal;

import jakarta.persistence.Convert;
import jakarta.persistence.Enumerated;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.MapKeyClass;
import jakarta.persistence.MapKeyEnumerated;
import jakarta.persistence.MapKeyTemporal;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Temporal;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.AssertionFailure;
import org.hibernate.annotations.CollectionType;
import org.hibernate.annotations.ManyToAny;
import org.hibernate.annotations.MapKeyType;
import org.hibernate.boot.model.convert.spi.ConverterAutoApplyHandler;
import org.hibernate.boot.model.convert.spi.ConverterDescriptor;
import org.hibernate.boot.model.internal.AbstractPropertyHolder;
import org.hibernate.boot.model.internal.AnnotatedColumns;
import org.hibernate.boot.model.internal.AttributeConversionInfo;
import org.hibernate.boot.model.internal.PropertyHolder;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.MemberDetails;
import org.hibernate.models.spi.TypeDetails;

public class CollectionPropertyHolder
extends AbstractPropertyHolder {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(CollectionPropertyHolder.class);
    private final Collection collection;
    private boolean canElementBeConverted = true;
    private boolean canKeyBeConverted = true;
    private final Map<String, AttributeConversionInfo> elementAttributeConversionInfoMap;
    private final Map<String, AttributeConversionInfo> keyAttributeConversionInfoMap;
    boolean prepared;

    public CollectionPropertyHolder(Collection collection, String path, ClassDetails clazzToProcess, MemberDetails property, PropertyHolder parentPropertyHolder, MetadataBuildingContext context) {
        super(path, parentPropertyHolder, clazzToProcess, context);
        this.collection = collection;
        this.setCurrentProperty(property);
        this.elementAttributeConversionInfoMap = new HashMap<String, AttributeConversionInfo>();
        this.keyAttributeConversionInfoMap = new HashMap<String, AttributeConversionInfo>();
    }

    public Collection getCollectionBinding() {
        return this.collection;
    }

    private void buildAttributeConversionInfoMaps(MemberDetails collectionProperty, boolean isComposite, Map<String, AttributeConversionInfo> elementAttributeConversionInfoMap, Map<String, AttributeConversionInfo> keyAttributeConversionInfoMap) {
        collectionProperty.forEachAnnotationUsage(Convert.class, this.getSourceModelContext(), usage -> this.applyLocalConvert((Convert)usage, collectionProperty, isComposite, elementAttributeConversionInfoMap, keyAttributeConversionInfoMap));
    }

    private void applyLocalConvert(Convert convertAnnotation, MemberDetails collectionProperty, boolean isComposite, Map<String, AttributeConversionInfo> elementAttributeConversionInfoMap, Map<String, AttributeConversionInfo> keyAttributeConversionInfoMap) {
        AttributeConversionInfo info = new AttributeConversionInfo(convertAnnotation, (AnnotationTarget)collectionProperty);
        String attributeName = info.getAttributeName();
        if (this.collection.isMap()) {
            CollectionPropertyHolder.logSpecNoncompliance(attributeName, this.collection.getRole());
        }
        if (StringHelper.isEmpty(attributeName)) {
            if (this.canElementBeConverted && this.canKeyBeConverted) {
                if (!isComposite) {
                    elementAttributeConversionInfoMap.put("", info);
                } else {
                    this.throwMissingAttributeName();
                }
            } else if (this.canKeyBeConverted) {
                keyAttributeConversionInfoMap.put("", info);
            } else if (this.canElementBeConverted) {
                elementAttributeConversionInfoMap.put("", info);
            }
        } else {
            String elementPath;
            String keyPath;
            if (this.canElementBeConverted && this.canKeyBeConverted) {
                keyPath = this.removePrefix(attributeName, "key");
                elementPath = this.removePrefix(attributeName, "value");
                if (keyPath == null && elementPath == null) {
                    this.throwMissingAttributeName();
                }
            } else if (this.canKeyBeConverted) {
                keyPath = this.removePrefix(attributeName, "key", attributeName);
                elementPath = null;
            } else {
                keyPath = null;
                elementPath = this.removePrefix(attributeName, "value", attributeName);
            }
            if (keyPath != null) {
                keyAttributeConversionInfoMap.put(keyPath, info);
            } else if (elementPath != null) {
                elementAttributeConversionInfoMap.put(elementPath, info);
            } else {
                throw new IllegalStateException(String.format(Locale.ROOT, "Could not determine how to apply @Convert(attributeName='%s') to collection [%s]", attributeName, this.collection.getRole()));
            }
        }
    }

    private void throwMissingAttributeName() {
        throw new IllegalStateException("'@Convert' annotation for map [" + this.collection.getRole() + "] must specify 'attributeName=\"key\"' or 'attributeName=\"value\"'");
    }

    private static void logSpecNoncompliance(String attributeName, String role) {
        boolean specCompliant;
        boolean bl = specCompliant = StringHelper.isNotEmpty(attributeName) && (attributeName.startsWith("key") || attributeName.startsWith("value"));
        if (!specCompliant) {
            LOG.nonCompliantMapConversion(role);
        }
    }

    private String removePrefix(String path, String prefix) {
        return this.removePrefix(path, prefix, null);
    }

    private String removePrefix(String path, String prefix, String defaultValue) {
        if (path.equals(prefix)) {
            return "";
        }
        if (path.startsWith(prefix + ".")) {
            return path.substring(prefix.length() + 1);
        }
        return defaultValue;
    }

    @Override
    protected String normalizeCompositePath(String attributeName) {
        return attributeName;
    }

    @Override
    protected String normalizeCompositePathForLogging(String attributeName) {
        return this.collection.getRole() + "." + attributeName;
    }

    @Override
    public void startingProperty(MemberDetails property) {
    }

    @Override
    protected AttributeConversionInfo locateAttributeConversionInfo(MemberDetails attributeMember) {
        return null;
    }

    @Override
    protected AttributeConversionInfo locateAttributeConversionInfo(String path) {
        String key = this.removePrefix(path, "key");
        if (key != null) {
            return this.keyAttributeConversionInfoMap.get(key);
        }
        String element = this.removePrefix(path, "element");
        if (element != null) {
            return this.elementAttributeConversionInfoMap.get(element);
        }
        return this.elementAttributeConversionInfoMap.get(path);
    }

    @Override
    public String getClassName() {
        throw new AssertionFailure("Collection property holder does not have a class name");
    }

    @Override
    public String getEntityOwnerClassName() {
        return null;
    }

    @Override
    public Table getTable() {
        return this.collection.getCollectionTable();
    }

    @Override
    public void addProperty(Property prop, MemberDetails memberDetails, ClassDetails declaringClass) {
        throw new AssertionFailure("Cannot add property to a collection");
    }

    @Override
    public void movePropertyToJoin(Property prop, Join join, MemberDetails memberDetails, ClassDetails declaringClass) {
        throw new AssertionFailure("Cannot add property to a collection");
    }

    @Override
    public KeyValue getIdentifier() {
        throw new AssertionFailure("Identifier collection not yet managed");
    }

    @Override
    public boolean isOrWithinEmbeddedId() {
        return false;
    }

    @Override
    public boolean isWithinElementCollection() {
        return false;
    }

    @Override
    public PersistentClass getPersistentClass() {
        return this.collection.getOwner();
    }

    @Override
    public boolean isComponent() {
        return false;
    }

    @Override
    public boolean isEntity() {
        return false;
    }

    @Override
    public String getEntityName() {
        return this.collection.getOwner().getEntityName();
    }

    @Override
    public void addProperty(Property prop, MemberDetails memberDetails, @Nullable AnnotatedColumns columns, ClassDetails declaringClass) {
        throw new AssertionFailure("addProperty to a join table of a collection: does it make sense?");
    }

    @Override
    public Join addJoin(JoinTable joinTableAnn, boolean noDelayInPkColumnCreation) {
        throw new AssertionFailure("Add join in a second pass");
    }

    @Override
    public Join addJoin(JoinTable joinTableAnn, Table table, boolean noDelayInPkColumnCreation) {
        throw new AssertionFailure("Add join in a second pass");
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.collection.getRole() + ")";
    }

    public void prepare(MemberDetails collectionProperty, boolean isComposite) {
        if (this.prepared) {
            return;
        }
        if (collectionProperty == null) {
            return;
        }
        this.prepared = true;
        if (this.collection.isMap()) {
            if (collectionProperty.hasDirectAnnotationUsage(MapKeyEnumerated.class)) {
                this.canKeyBeConverted = false;
            } else if (collectionProperty.hasDirectAnnotationUsage(MapKeyTemporal.class)) {
                this.canKeyBeConverted = false;
            } else if (collectionProperty.hasDirectAnnotationUsage(MapKeyClass.class)) {
                this.canKeyBeConverted = false;
            } else if (collectionProperty.hasDirectAnnotationUsage(MapKeyType.class)) {
                this.canKeyBeConverted = false;
            }
        } else {
            this.canKeyBeConverted = false;
        }
        if (collectionProperty.hasDirectAnnotationUsage(ManyToAny.class)) {
            this.canElementBeConverted = false;
        } else if (collectionProperty.hasDirectAnnotationUsage(OneToMany.class)) {
            this.canElementBeConverted = false;
        } else if (collectionProperty.hasDirectAnnotationUsage(ManyToMany.class)) {
            this.canElementBeConverted = false;
        } else if (collectionProperty.hasDirectAnnotationUsage(Enumerated.class)) {
            this.canElementBeConverted = false;
        } else if (collectionProperty.hasDirectAnnotationUsage(Temporal.class)) {
            this.canElementBeConverted = false;
        } else if (collectionProperty.hasDirectAnnotationUsage(CollectionType.class)) {
            this.canElementBeConverted = false;
        }
        if (this.canKeyBeConverted || this.canElementBeConverted) {
            this.buildAttributeConversionInfoMaps(collectionProperty, isComposite, this.elementAttributeConversionInfoMap, this.keyAttributeConversionInfoMap);
        }
    }

    public ConverterDescriptor<?, ?> resolveElementAttributeConverterDescriptor(MemberDetails memberDetails, ClassDetails classDetails) {
        AttributeConversionInfo info = this.locateAttributeConversionInfo("element");
        if (info != null) {
            if (info.isConversionDisabled()) {
                return null;
            }
            try {
                return this.makeAttributeConverterDescriptor(info);
            }
            catch (Exception e) {
                throw this.buildExceptionFromInstantiationError(info, e);
            }
        }
        return this.getAttributeConverterAutoApplyHandler().findAutoApplyConverterForCollectionElement(memberDetails, this.getContext());
    }

    public ConverterDescriptor<?, ?> mapKeyAttributeConverterDescriptor(MemberDetails memberDetails, TypeDetails keyTypeDetails) {
        AttributeConversionInfo info = this.locateAttributeConversionInfo("key");
        if (info != null) {
            if (info.isConversionDisabled()) {
                return null;
            }
            try {
                return this.makeAttributeConverterDescriptor(info);
            }
            catch (Exception e) {
                throw this.buildExceptionFromInstantiationError(info, e);
            }
        }
        return this.getAttributeConverterAutoApplyHandler().findAutoApplyConverterForMapKey(memberDetails, this.getContext());
    }

    private ConverterAutoApplyHandler getAttributeConverterAutoApplyHandler() {
        return this.getContext().getMetadataCollector().getConverterRegistry().getAttributeConverterAutoApplyHandler();
    }
}

