/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.revui.app.download.metadata.repo;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.revrobotics.revui.app.download.DownloadContext;
import com.revrobotics.revui.app.download.metadata.repo.model.Metadata;
import com.revrobotics.revui.app.download.metadata.repo.model.SoftwareContext;
import com.revrobotics.revui.app.download.metadata.repo.model.SoftwareEntry;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class MetadataHandler {
    private static final ObjectMapper mapper = MetadataHandler.createMapper();
    private static final String METADATA_URL = "https://storage.googleapis.com/revui-public-version-metadata/metadata.yaml";

    private static String getMetadataContents() throws IOException {
        URI uri = URI.create(METADATA_URL);
        try (InputStream stream = uri.toURL().openStream();){
            String string = new String(stream.readAllBytes(), StandardCharsets.UTF_8);
            return string;
        }
    }

    public static Metadata getMetadata() throws IOException {
        String contents = MetadataHandler.getMetadataContents();
        return (Metadata)mapper.readValue(contents, Metadata.class);
    }

    private static ObjectMapper createMapper() {
        return ((YAMLMapper.Builder)((YAMLMapper.Builder)((YAMLMapper.Builder)YAMLMapper.builder().addModule((Module)new JavaTimeModule())).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE, true)).build();
    }

    private static SoftwareContext toSoftwareContext(DownloadContext context) {
        return switch (context) {
            default -> throw new MatchException(null, null);
            case DownloadContext.SPARK_MAX -> SoftwareContext.SparkMax;
            case DownloadContext.SPARK_FLEX -> SoftwareContext.SparkFlex;
            case DownloadContext.PDH -> SoftwareContext.PowerHub;
            case DownloadContext.PH -> SoftwareContext.PneumaticsHub;
            case DownloadContext.SERVO_HUB -> SoftwareContext.ServoHub;
            case DownloadContext.REVLib -> SoftwareContext.REVLib;
            case DownloadContext.MAXSPLINE_ENCODER -> SoftwareContext.MAXSplineEncoder;
        };
    }

    public static List<SoftwareEntry> getSoftwareEntries(Metadata metadata, DownloadContext context) {
        return MetadataHandler.getSoftwareEntries(metadata, MetadataHandler.toSoftwareContext(context));
    }

    public static List<SoftwareEntry> getSoftwareEntries(Metadata metadata, SoftwareContext context) {
        return metadata.softwareEntries().stream().filter(entry -> entry.context().equals((Object)context)).toList();
    }
}

