/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.revui.app.files;

import ca.gosyer.appdirs.AppDirs;
import ca.gosyer.appdirs.AppDirsKt;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public abstract class DirectoryManager {
    private static AppDirs appDirs;

    private static AppDirs getAppDirs() {
        if (appDirs == null) {
            appDirs = AppDirsKt.AppDirs(config -> {
                config.setAppName("REV Hardware Client 2");
                config.setAppAuthor("REV Robotics");
                return null;
            });
        }
        return appDirs;
    }

    private static Path getNonRoamingPath() {
        AppDirs dirs = DirectoryManager.getAppDirs();
        Path result = Path.of(dirs.getUserDataDir(false), new String[0]);
        try {
            Files.createDirectories(result, new FileAttribute[0]);
        }
        catch (IOException e) {
            System.out.println("Unable to create user directory: " + e.getMessage());
        }
        return result;
    }

    public static Path getDownloadsPath() {
        Path downloadPath = DirectoryManager.getNonRoamingPath().resolve("downloads");
        try {
            Files.createDirectories(downloadPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            System.out.println("Unable to create download directory: " + e.getMessage());
        }
        return downloadPath;
    }

    public static Path getSqlitePath() {
        Path sqlitePath = DirectoryManager.getNonRoamingPath().resolve("sqlite");
        try {
            Files.createDirectories(sqlitePath, new FileAttribute[0]);
        }
        catch (IOException e) {
            System.out.println("Unable to create sqlite directory: " + e.getMessage());
        }
        return sqlitePath;
    }

    public static Path getTracingPath() {
        Path downloadPath = DirectoryManager.getNonRoamingPath().resolve("traces");
        try {
            Files.createDirectories(downloadPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            System.out.println("Unable to create traces directory: " + e.getMessage());
        }
        return downloadPath;
    }

    public static Path getLogPath() {
        Path logPath = DirectoryManager.getNonRoamingPath().resolve("logs");
        try {
            Files.createDirectories(logPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            System.out.println("Unable to create log directory: " + e.getMessage());
        }
        return logPath;
    }

    public static Path getLocalStoragePath() {
        Path localStoragePath = DirectoryManager.getNonRoamingPath().resolve("chromium");
        try {
            Files.createDirectories(localStoragePath, new FileAttribute[0]);
        }
        catch (IOException e) {
            System.out.println("Unable to create chromium storage directory: " + e.getMessage());
        }
        return localStoragePath;
    }

    public static Path getAppStoragePath() {
        Path appStoragePath = DirectoryManager.getNonRoamingPath().resolve("app-storage");
        try {
            Files.createDirectories(appStoragePath, new FileAttribute[0]);
        }
        catch (IOException e) {
            System.out.println("Unable to create app storage directory: " + e.getMessage());
        }
        return appStoragePath;
    }

    public static Path getExecutableDirectory() {
        Path executablePath = DirectoryManager.getNonRoamingPath().resolve("executable");
        try {
            Files.createDirectories(executablePath, new FileAttribute[0]);
        }
        catch (IOException e) {
            System.out.println("Unable to create executable directory: " + e.getMessage());
        }
        return executablePath;
    }

    public static Path getTempDirectory() {
        Path tempPath = DirectoryManager.getNonRoamingPath().resolve("temp");
        try {
            Files.createDirectories(tempPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            System.out.println("Unable to create temp directory: " + e.getMessage());
        }
        return tempPath;
    }
}

