/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.web.format;

import java.time.format.DateTimeFormatter;
import java.time.format.ResolverStyle;
import org.jspecify.annotations.Nullable;
import org.springframework.util.StringUtils;

public class DateTimeFormatters {
    private @Nullable DateTimeFormatter dateFormatter;
    private @Nullable String datePattern;
    private @Nullable DateTimeFormatter timeFormatter;
    private @Nullable DateTimeFormatter dateTimeFormatter;

    public DateTimeFormatters dateFormat(@Nullable String pattern) {
        if (DateTimeFormatters.isIso(pattern)) {
            this.dateFormatter = DateTimeFormatter.ISO_LOCAL_DATE;
            this.datePattern = "yyyy-MM-dd";
        } else {
            this.dateFormatter = DateTimeFormatters.formatter(pattern);
            this.datePattern = pattern;
        }
        return this;
    }

    public DateTimeFormatters timeFormat(@Nullable String pattern) {
        this.timeFormatter = DateTimeFormatters.isIso(pattern) ? DateTimeFormatter.ISO_LOCAL_TIME : (DateTimeFormatters.isIsoOffset(pattern) ? DateTimeFormatter.ISO_OFFSET_TIME : DateTimeFormatters.formatter(pattern));
        return this;
    }

    public DateTimeFormatters dateTimeFormat(@Nullable String pattern) {
        this.dateTimeFormatter = DateTimeFormatters.isIso(pattern) ? DateTimeFormatter.ISO_LOCAL_DATE_TIME : (DateTimeFormatters.isIsoOffset(pattern) ? DateTimeFormatter.ISO_OFFSET_DATE_TIME : DateTimeFormatters.formatter(pattern));
        return this;
    }

    @Nullable DateTimeFormatter getDateFormatter() {
        return this.dateFormatter;
    }

    @Nullable String getDatePattern() {
        return this.datePattern;
    }

    @Nullable DateTimeFormatter getTimeFormatter() {
        return this.timeFormatter;
    }

    @Nullable DateTimeFormatter getDateTimeFormatter() {
        return this.dateTimeFormatter;
    }

    boolean isCustomized() {
        return this.dateFormatter != null || this.timeFormatter != null || this.dateTimeFormatter != null;
    }

    private static @Nullable DateTimeFormatter formatter(@Nullable String pattern) {
        return StringUtils.hasText((String)pattern) ? DateTimeFormatter.ofPattern(pattern).withResolverStyle(ResolverStyle.SMART) : null;
    }

    private static boolean isIso(@Nullable String pattern) {
        return "iso".equalsIgnoreCase(pattern);
    }

    private static boolean isIsoOffset(@Nullable String pattern) {
        return "isooffset".equalsIgnoreCase(pattern) || "iso-offset".equalsIgnoreCase(pattern);
    }
}

