/*
 * Decompiled with CFR 0.152.
 */
package io.github.wimdeblauwe.htmx.spring.boot.mvc;

import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxResponse;
import jakarta.servlet.http.HttpServletRequest;

final class RequestContextUtils {
    public static final String HTMX_RESPONSE_CONTEXT_ATTRIBUTE = "htmxResponse";

    static String createUrl(HttpServletRequest request, String url, boolean contextRelative) {
        if (contextRelative && url.startsWith("/")) {
            return RequestContextUtils.getContextPath(request) + url;
        }
        return url;
    }

    static HtmxResponse getHtmxResponse(HttpServletRequest request) {
        Object contextAttribute = request.getAttribute(HTMX_RESPONSE_CONTEXT_ATTRIBUTE);
        if (contextAttribute instanceof HtmxResponse) {
            HtmxResponse response = (HtmxResponse)contextAttribute;
            return response;
        }
        return null;
    }

    private static String getContextPath(HttpServletRequest request) {
        String contextPath = request.getContextPath();
        while (contextPath.startsWith("//")) {
            contextPath = contextPath.substring(1);
        }
        return contextPath;
    }

    private RequestContextUtils() {
    }
}

