/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.endpoint.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import org.springframework.boot.actuate.endpoint.jackson.EndpointJsonMapper;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import tools.jackson.databind.json.JsonMapper;

@AutoConfiguration
@ConditionalOnClass(value={JsonMapper.class})
public final class JacksonEndpointAutoConfiguration {
    @Bean
    @ConditionalOnBooleanProperty(name={"management.endpoints.jackson.isolated-json-mapper"}, matchIfMissing=true)
    EndpointJsonMapper endpointJsonMapper() {
        JsonMapper jsonMapper = ((JsonMapper.Builder)JsonMapper.builder().changeDefaultPropertyInclusion(value -> value.withValueInclusion(JsonInclude.Include.NON_NULL).withContentInclusion(JsonInclude.Include.NON_NULL))).build();
        return () -> jsonMapper;
    }
}

