/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jdbc.docker.compose;

import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;
import org.springframework.boot.jdbc.autoconfigure.JdbcConnectionDetails;
import org.springframework.boot.jdbc.docker.compose.OracleContainer;
import org.springframework.boot.jdbc.docker.compose.OracleEnvironment;
import org.springframework.util.StringUtils;

abstract class OracleJdbcDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<JdbcConnectionDetails> {
    private final String defaultDatabase;

    protected OracleJdbcDockerComposeConnectionDetailsFactory(OracleContainer container) {
        super(container.getImageName(), new String[0]);
        this.defaultDatabase = container.getDefaultDatabase();
    }

    protected JdbcConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new OracleJdbcDockerComposeConnectionDetails(source.getRunningService(), this.defaultDatabase);
    }

    static class OracleJdbcDockerComposeConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements JdbcConnectionDetails {
        private static final String PARAMETERS_LABEL = "org.springframework.boot.jdbc.parameters";
        private final OracleEnvironment environment;
        private final String jdbcUrl;

        OracleJdbcDockerComposeConnectionDetails(RunningService service, String defaultDatabase) {
            super(service);
            this.environment = new OracleEnvironment(service.env(), defaultDatabase);
            this.jdbcUrl = "jdbc:oracle:thin:@" + service.host() + ":" + service.ports().get(1521) + "/" + this.environment.getDatabase() + this.getParameters(service);
        }

        private String getParameters(RunningService service) {
            String parameters = (String)service.labels().get(PARAMETERS_LABEL);
            return StringUtils.hasLength((String)parameters) ? "?" + parameters : "";
        }

        @Override
        public String getUsername() {
            return this.environment.getUsername();
        }

        @Override
        public String getPassword() {
            return this.environment.getPassword();
        }

        @Override
        public String getJdbcUrl() {
            return this.jdbcUrl;
        }
    }
}

