/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.revui.app;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.revrobotics.device.detection.DeviceDaemon;
import com.revrobotics.device.detection.dfu.DfuDevice;
import com.revrobotics.device.detection.dfu.DfuManager;
import com.revrobotics.revui.app.annotations.StandardExceptions;
import com.revrobotics.revui.app.annotations.Success;
import com.revrobotics.revui.app.files.DirectoryManager;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/v1/dfu"})
public class DfuController {
    @Autowired
    DfuManager manager;
    @Autowired
    DeviceDaemon deviceDaemon;

    @Success
    @GetMapping(value={"/device/list"})
    public DfuDevice[] listDevices() {
        return this.manager.listDevices().toArray(new DfuDevice[0]);
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/device/flash"}, consumes={"multipart/form-data"})
    @Success
    @StandardExceptions
    public void flashDevice(@Parameter(required=true, schema=@Schema(implementation=DfuDevice.class)) @RequestPart(value="device") String device, @RequestPart(value="file") MultipartFile file, boolean leave) {
        Path tempDir = DirectoryManager.getTempDirectory();
        Path tempFile = tempDir.resolve("dfu-" + System.nanoTime() + ".dfu");
        try {
            Files.copy(file.getInputStream(), tempFile, StandardCopyOption.REPLACE_EXISTING);
            System.out.print("File to be written to device" + String.valueOf(tempFile));
            ObjectMapper mapper = new ObjectMapper();
            DfuDevice dfuDevice = (DfuDevice)mapper.readValue(device, DfuDevice.class);
            Thread flashThread = new Thread(() -> this.flashDfuDevice(leave, dfuDevice, tempFile));
            flashThread.setName("Device flash thread");
            flashThread.setDaemon(true);
            flashThread.start();
            flashThread.join();
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                Files.deleteIfExists(tempFile);
            }
            catch (IOException iOException) {}
        }
    }

    private void flashDfuDevice(boolean leave, DfuDevice dfuDevice, Path tempFile) {
        this.deviceDaemon.getDetector().addDfuUpdatingDevice(dfuDevice);
        this.manager.flashDevice(dfuDevice, tempFile, leave);
        this.deviceDaemon.getDetector().removeDfuUpdatingDevice(dfuDevice);
    }
}

