/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.origin;

import org.jspecify.annotations.Nullable;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.OriginProvider;
import org.springframework.lang.Contract;
import org.springframework.util.ObjectUtils;

public class OriginTrackedValue
implements OriginProvider {
    private final Object value;
    private final @Nullable Origin origin;

    private OriginTrackedValue(Object value, @Nullable Origin origin) {
        this.value = value;
        this.origin = origin;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public @Nullable Origin getOrigin() {
        return this.origin;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.value, (Object)((OriginTrackedValue)obj).value);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode((Object)this.value);
    }

    public @Nullable String toString() {
        return this.value != null ? this.value.toString() : null;
    }

    @Contract(value="!null -> !null")
    public static @Nullable OriginTrackedValue of(@Nullable Object value) {
        return OriginTrackedValue.of(value, null);
    }

    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static @Nullable OriginTrackedValue of(@Nullable Object value, @Nullable Origin origin) {
        if (value == null) {
            return null;
        }
        if (value instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)value;
            return new OriginTrackedCharSequence(charSequence, origin);
        }
        return new OriginTrackedValue(value, origin);
    }

    private static class OriginTrackedCharSequence
    extends OriginTrackedValue
    implements CharSequence {
        OriginTrackedCharSequence(CharSequence value, @Nullable Origin origin) {
            super(value, origin);
        }

        @Override
        public int length() {
            return this.getValue().length();
        }

        @Override
        public char charAt(int index) {
            return this.getValue().charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.getValue().subSequence(start, end);
        }

        @Override
        public CharSequence getValue() {
            return (CharSequence)super.getValue();
        }
    }
}

