/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics;

import com.revrobotics.StatusFrameEmitter;
import com.revrobotics.encoder.DetachedEncoder;
import java.util.UUID;

public class EncoderFrameEmitter
extends StatusFrameEmitter {
    private final DetachedEncoder encoder;
    private final StatusDataCallback statusDataCallback;
    private final String descriptor;
    private final UUID uuid;
    private final String messageName;

    public EncoderFrameEmitter(String descriptor, UUID uuid, DetachedEncoder encoder, StatusDataCallback statusDataCallback, StatusFrameEmitter.OnStopCallback onStopCallback) {
        super(onStopCallback, 5);
        this.encoder = encoder;
        this.statusDataCallback = statusDataCallback;
        this.descriptor = descriptor;
        this.uuid = uuid;
        this.messageName = "Encoder " + encoder.getDeviceId();
    }

    @Override
    public void runFrameEmitter() {
        try {
            DetachedEncoder.PeriodicStatus0 status0 = this.encoder.getStatus0();
            DetachedEncoder.PeriodicStatus1 status1 = null;
            DetachedEncoder.PeriodicStatus2 status2 = null;
            DetachedEncoder.PeriodicStatus3 status3 = null;
            DetachedEncoder.PeriodicStatus4 status4 = null;
            if (this.frameEnabled[1]) {
                status1 = this.encoder.getStatus1();
            }
            if (this.frameEnabled[2]) {
                status2 = this.encoder.getStatus2();
            }
            if (this.frameEnabled[3]) {
                status3 = this.encoder.getStatus3();
            }
            if (this.frameEnabled[4]) {
                status4 = this.encoder.getStatus4();
            }
            Data statusData = new Data(status0, status1, status2, status3, status4);
            EncoderStatusData data = new EncoderStatusData(this.getTimestamp(), this.messageName, this.descriptor, this.uuid, statusData);
            if (this.statusDataCallback != null) {
                this.statusDataCallback.onEncoderFrameData(data);
            }
        }
        catch (IllegalStateException e) {
            this.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected String getThreadName() {
        return "EncoderFrameEmitter(" + this.encoder.getDeviceId() + ")";
    }

    public static interface StatusDataCallback {
        public void onEncoderFrameData(EncoderStatusData var1);
    }

    public record Data(DetachedEncoder.PeriodicStatus0 status0, DetachedEncoder.PeriodicStatus1 status1, DetachedEncoder.PeriodicStatus2 status2, DetachedEncoder.PeriodicStatus3 status3, DetachedEncoder.PeriodicStatus4 status4) {
    }

    public record EncoderStatusData(double timestamp, String name, String descriptor, UUID uuid, Data data) {
    }
}

