/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.can.spec;

public class EncoderCanSpec {
    public static final int BOOTLOADER_0_FRAME_ID = 117813248;
    public static final int PERIODIC_FRAME_0_FRAME_ID = 117815296;
    public static final int PERIODIC_FRAME_1_FRAME_ID = 117815360;
    public static final int PERIODIC_FRAME_2_FRAME_ID = 117815424;
    public static final int PERIODIC_FRAME_3_FRAME_ID = 117815488;
    public static final int PERIODIC_FRAME_4_FRAME_ID = 117815552;
    public static final int UNIQUE_ID_RESP_FRAME_ID = 117774336;
    public static final int GET_UNIQUE_IDS_FRAME_ID = 117775360;
    public static final int RESTORE_DEFAULTS_FRAME_ID = 117780480;
    public static final int RESTORE_DEFAULTS_RESP_FRAME_ID = 117780544;
    public static final int GET_PRODUCT_ID_FRAME_ID = 117780608;
    public static final int GET_PRODUCT_ID_RESP_FRAME_ID = 117780672;
    public static final int GET_VERSIONING_FRAME_ID = 117782528;
    public static final int GET_VERSIONING_RESP_FRAME_ID = 117782592;
    public static final int GET_PERIODIC_FRAME_PERIOD_FRAME_ID = 117782656;
    public static final int GET_PERIODIC_FRAME_PERIOD_RESP_FRAME_ID = 117782720;
    public static final int GET_NAME_FRAME_ID = 117782784;
    public static final int GET_NAME_RESP_FRAME_ID = 117782848;
    public static final int GET_POSITION_CONV_FACTOR_FRAME_ID = 117782912;
    public static final int GET_POSITION_CONV_FACTOR_RESP_FRAME_ID = 117782976;
    public static final int GET_VELOCITY_CONV_FACTOR_FRAME_ID = 117783040;
    public static final int GET_VELOCITY_CONV_FACTOR_RESP_FRAME_ID = 117783104;
    public static final int GET_ANGLE_OFFSET_FRAME_ID = 117783168;
    public static final int GET_ANGLE_OFFSET_RESP_FRAME_ID = 117783232;
    public static final int GET_VELOCITY_AVG_SAMPLES_FRAME_ID = 117783424;
    public static final int GET_VELOCITY_AVG_SAMPLES_RESP_FRAME_ID = 117783488;
    public static final int SET_CAN_ID_FRAME_ID = 117784576;
    public static final int SET_CAN_ID_RESP_FRAME_ID = 117784640;
    public static final int SET_PERIODIC_FRAME_PERIOD_FRAME_ID = 117784704;
    public static final int SET_PERIODIC_FRAME_PERIOD_RESP_FRAME_ID = 117784768;
    public static final int SET_NAME_FRAME_ID = 117784832;
    public static final int SET_NAME_RESP_FRAME_ID = 117784896;
    public static final int SET_POSITION_CONV_FACTOR_FRAME_ID = 117784960;
    public static final int SET_POSITION_CONV_FACTOR_RESP_FRAME_ID = 117785024;
    public static final int SET_VELOCITY_CONV_FACTOR_FRAME_ID = 117785088;
    public static final int SET_VELOCITY_CONV_FACTOR_RESP_FRAME_ID = 117785152;
    public static final int SET_ANGLE_OFFSET_FRAME_ID = 117785216;
    public static final int SET_ANGLE_OFFSET_RESP_FRAME_ID = 117785280;
    public static final int SET_VELOCITY_AVG_SAMPLES_FRAME_ID = 117785472;
    public static final int SET_VELOCITY_AVG_SAMPLES_RESP_FRAME_ID = 117785536;
    public static final int GET_INVERSION_FRAME_ID = 117786624;
    public static final int GET_INVERSION_RESP_FRAME_ID = 117786688;
    public static final int GET_ZERO_CENTERED_FRAME_ID = 117786752;
    public static final int GET_ZERO_CENTERED_RESP_FRAME_ID = 117786816;
    public static final int GET_ABS_AVG_DEPTH_FRAME_ID = 117786880;
    public static final int GET_ABS_AVG_DEPTH_RESP_FRAME_ID = 117786944;
    public static final int SET_INVERSION_FRAME_ID = 0x7055000;
    public static final int SET_INVERSION_RESP_FRAME_ID = 117788736;
    public static final int SET_ZERO_CENTERED_FRAME_ID = 117788800;
    public static final int SET_ZERO_CENTERED_RESP_FRAME_ID = 117788864;
    public static final int SET_ABS_AVG_DEPTH_FRAME_ID = 117788928;
    public static final int SET_ABS_AVG_DEPTH_RESP_FRAME_ID = 117788992;
    public static final int IDENTIFY_FRAME_ID = 117798912;
    public static final int SET_ENCODER_POSITION_FRAME_ID = 117798976;
    public static final int CLEAR_FAULTS_FRAME_ID = 117799040;
    public static final int BOOTLOADER_0_LENGTH = 8;
    public static final int PERIODIC_FRAME_0_LENGTH = 1;
    public static final int PERIODIC_FRAME_1_LENGTH = 2;
    public static final int PERIODIC_FRAME_2_LENGTH = 8;
    public static final int PERIODIC_FRAME_3_LENGTH = 8;
    public static final int PERIODIC_FRAME_4_LENGTH = 8;
    public static final int UNIQUE_ID_RESP_LENGTH = 4;
    public static final int GET_UNIQUE_IDS_LENGTH = 0;
    public static final int RESTORE_DEFAULTS_LENGTH = 4;
    public static final int RESTORE_DEFAULTS_RESP_LENGTH = 1;
    public static final int GET_PRODUCT_ID_LENGTH = 0;
    public static final int GET_PRODUCT_ID_RESP_LENGTH = 2;
    public static final int GET_VERSIONING_LENGTH = 0;
    public static final int GET_VERSIONING_RESP_LENGTH = 6;
    public static final int GET_PERIODIC_FRAME_PERIOD_LENGTH = 1;
    public static final int GET_PERIODIC_FRAME_PERIOD_RESP_LENGTH = 4;
    public static final int GET_NAME_LENGTH = 0;
    public static final int GET_NAME_RESP_LENGTH = 7;
    public static final int GET_POSITION_CONV_FACTOR_LENGTH = 0;
    public static final int GET_POSITION_CONV_FACTOR_RESP_LENGTH = 5;
    public static final int GET_VELOCITY_CONV_FACTOR_LENGTH = 0;
    public static final int GET_VELOCITY_CONV_FACTOR_RESP_LENGTH = 5;
    public static final int GET_ANGLE_OFFSET_LENGTH = 0;
    public static final int GET_ANGLE_OFFSET_RESP_LENGTH = 5;
    public static final int GET_VELOCITY_AVG_SAMPLES_LENGTH = 0;
    public static final int GET_VELOCITY_AVG_SAMPLES_RESP_LENGTH = 3;
    public static final int SET_CAN_ID_LENGTH = 5;
    public static final int SET_CAN_ID_RESP_LENGTH = 1;
    public static final int SET_PERIODIC_FRAME_PERIOD_LENGTH = 3;
    public static final int SET_PERIODIC_FRAME_PERIOD_RESP_LENGTH = 2;
    public static final int SET_NAME_LENGTH = 6;
    public static final int SET_NAME_RESP_LENGTH = 2;
    public static final int SET_POSITION_CONV_FACTOR_LENGTH = 4;
    public static final int SET_POSITION_CONV_FACTOR_RESP_LENGTH = 1;
    public static final int SET_VELOCITY_CONV_FACTOR_LENGTH = 4;
    public static final int SET_VELOCITY_CONV_FACTOR_RESP_LENGTH = 1;
    public static final int SET_ANGLE_OFFSET_LENGTH = 4;
    public static final int SET_ANGLE_OFFSET_RESP_LENGTH = 1;
    public static final int SET_VELOCITY_AVG_SAMPLES_LENGTH = 1;
    public static final int SET_VELOCITY_AVG_SAMPLES_RESP_LENGTH = 1;
    public static final int GET_INVERSION_LENGTH = 0;
    public static final int GET_INVERSION_RESP_LENGTH = 2;
    public static final int GET_ZERO_CENTERED_LENGTH = 0;
    public static final int GET_ZERO_CENTERED_RESP_LENGTH = 2;
    public static final int GET_ABS_AVG_DEPTH_LENGTH = 0;
    public static final int GET_ABS_AVG_DEPTH_RESP_LENGTH = 2;
    public static final int SET_INVERSION_LENGTH = 1;
    public static final int SET_INVERSION_RESP_LENGTH = 1;
    public static final int SET_ZERO_CENTERED_LENGTH = 1;
    public static final int SET_ZERO_CENTERED_RESP_LENGTH = 1;
    public static final int SET_ABS_AVG_DEPTH_LENGTH = 1;
    public static final int SET_ABS_AVG_DEPTH_RESP_LENGTH = 1;
    public static final int IDENTIFY_LENGTH = 0;
    public static final int SET_ENCODER_POSITION_LENGTH = 4;
    public static final int CLEAR_FAULTS_LENGTH = 0;

    private static int packLeftShift(int value, int shift, int mask) {
        return value << shift & mask & 0xFF;
    }

    private static int packRightShift(int value, int shift, int mask) {
        return value >> shift & mask & 0xFF;
    }

    private static int unpackLeftShift8(int value, int shift, int mask) {
        return (value & mask) << shift & 0xFF;
    }

    private static int unpackLeftShift16(int value, int shift, int mask) {
        return (value & mask) << shift & 0xFFFF;
    }

    private static int unpackLeftShift32(int value, int shift, int mask) {
        return (value & mask) << shift & 0xFFFFFFFF;
    }

    private static int unpackRightShift8(int value, int shift, int mask) {
        return (value & mask) >> shift & 0xFF;
    }

    private static int unpackRightShift16(int value, int shift, int mask) {
        return (value & mask) >> shift & 0xFFFF;
    }

    private static int unpackRightShift32(int value, int shift, int mask) {
        return (value & mask) >> shift & 0xFFFFFFFF;
    }

    public static Bootloader0 bootloader0Unpack(byte[] data) {
        int bLMajor = EncoderCanSpec.unpackIntBits(data, 0, 8);
        int bLMinor = EncoderCanSpec.unpackIntBits(data, 8, 8);
        int productID = EncoderCanSpec.unpackIntBits(data, 16, 16);
        int rsvd = EncoderCanSpec.unpackIntBits(data, 32, 32);
        return new Bootloader0(bLMajor, bLMinor, productID, rsvd);
    }

    public static PeriodicFrame0 periodicFrame0Unpack(byte[] data) {
        int deviceModel = EncoderCanSpec.unpackIntBits(data, 0, 8);
        return new PeriodicFrame0(deviceModel);
    }

    public static PeriodicFrame1 periodicFrame1Unpack(byte[] data) {
        boolean unexpected = (data[0] & 1) != 0;
        boolean hasReset = (data[0] & 2) != 0;
        boolean cANTX = (data[0] & 4) != 0;
        boolean cANRX = (data[0] & 8) != 0;
        boolean eEPROM = (data[0] & 0x10) != 0;
        int rsvd1 = EncoderCanSpec.unpackIntBits(data, 5, 3);
        boolean stickyUnexpected = (data[1] & 1) != 0;
        boolean stickyHasReset = (data[1] & 2) != 0;
        boolean stickyCANTX = (data[1] & 4) != 0;
        boolean stickyCANRX = (data[1] & 8) != 0;
        boolean stickyEEPROM = (data[1] & 0x10) != 0;
        int stickyRsvd1 = EncoderCanSpec.unpackIntBits(data, 13, 3);
        return new PeriodicFrame1(unexpected, hasReset, cANTX, cANRX, eEPROM, rsvd1, stickyUnexpected, stickyHasReset, stickyCANTX, stickyCANRX, stickyEEPROM, stickyRsvd1);
    }

    public static PeriodicFrame2 periodicFrame2Unpack(byte[] data) {
        int timestamp = EncoderCanSpec.unpackIntBits(data, 0, 32);
        int angleInt = data[4] | data[5] << 8 | data[6] << 16 | data[7] << 24;
        float angle = Float.intBitsToFloat(angleInt);
        return new PeriodicFrame2(timestamp, angle);
    }

    public static PeriodicFrame3 periodicFrame3Unpack(byte[] data) {
        int timestamp = EncoderCanSpec.unpackIntBits(data, 0, 32);
        int positionInt = data[4] | data[5] << 8 | data[6] << 16 | data[7] << 24;
        float position = Float.intBitsToFloat(positionInt);
        return new PeriodicFrame3(timestamp, position);
    }

    public static PeriodicFrame4 periodicFrame4Unpack(byte[] data) {
        int timestamp = EncoderCanSpec.unpackIntBits(data, 0, 32);
        int velocityInt = data[4] | data[5] << 8 | data[6] << 16 | data[7] << 24;
        float velocity = Float.intBitsToFloat(velocityInt);
        return new PeriodicFrame4(timestamp, velocity);
    }

    public static UniqueIDResp uniqueIDRespUnpack(byte[] data) {
        int iD = EncoderCanSpec.unpackIntBits(data, 0, 32);
        return new UniqueIDResp(iD);
    }

    public static GetUniqueIDs getUniqueIDsUnpack(byte[] data) {
        return new GetUniqueIDs();
    }

    public static RestoreDefaults restoreDefaultsUnpack(byte[] data) {
        int key = EncoderCanSpec.unpackIntBits(data, 0, 32);
        return new RestoreDefaults(key);
    }

    public static RestoreDefaultsResp restoreDefaultsRespUnpack(byte[] data) {
        int error = EncoderCanSpec.unpackIntBits(data, 0, 8);
        return new RestoreDefaultsResp(error);
    }

    public static GetProductID getProductIDUnpack(byte[] data) {
        return new GetProductID();
    }

    public static GetProductIDResp getProductIDRespUnpack(byte[] data) {
        int iD = EncoderCanSpec.unpackIntBits(data, 0, 16);
        return new GetProductIDResp(iD);
    }

    public static GetVersioning getVersioningUnpack(byte[] data) {
        return new GetVersioning();
    }

    public static GetVersioningResp getVersioningRespUnpack(byte[] data) {
        int hWMinor = EncoderCanSpec.unpackIntBits(data, 0, 8);
        int hWMajor = EncoderCanSpec.unpackIntBits(data, 8, 8);
        int sWPreRelease = EncoderCanSpec.unpackIntBits(data, 16, 8);
        int sWFix = EncoderCanSpec.unpackIntBits(data, 24, 8);
        int sWMinor = EncoderCanSpec.unpackIntBits(data, 32, 8);
        int sWMajor = EncoderCanSpec.unpackIntBits(data, 40, 8);
        return new GetVersioningResp(hWMinor, hWMajor, sWPreRelease, sWFix, sWMinor, sWMajor);
    }

    public static GetPeriodicFramePeriod getPeriodicFramePeriodUnpack(byte[] data) {
        int frameIdx = EncoderCanSpec.unpackIntBits(data, 0, 8);
        return new GetPeriodicFramePeriod(frameIdx);
    }

    public static GetPeriodicFramePeriodResp getPeriodicFramePeriodRespUnpack(byte[] data) {
        int error = EncoderCanSpec.unpackIntBits(data, 0, 8);
        int frameIdx = EncoderCanSpec.unpackIntBits(data, 8, 8);
        int period = EncoderCanSpec.unpackIntBits(data, 16, 16);
        return new GetPeriodicFramePeriodResp(error, frameIdx, period);
    }

    public static GetName getNameUnpack(byte[] data) {
        return new GetName();
    }

    public static GetNameResp getNameRespUnpack(byte[] data) {
        int error = EncoderCanSpec.unpackIntBits(data, 0, 8);
        int index = EncoderCanSpec.unpackIntBits(data, 8, 8);
        int c3 = EncoderCanSpec.unpackIntBits(data, 16, 8);
        int c2 = EncoderCanSpec.unpackIntBits(data, 24, 8);
        int c1 = EncoderCanSpec.unpackIntBits(data, 32, 8);
        int c0 = EncoderCanSpec.unpackIntBits(data, 40, 8);
        int isEnd = EncoderCanSpec.unpackIntBits(data, 48, 8);
        return new GetNameResp(error, index, c3, c2, c1, c0, isEnd);
    }

    public static GetPositionConvFactor getPositionConvFactorUnpack(byte[] data) {
        return new GetPositionConvFactor();
    }

    public static GetPositionConvFactorResp getPositionConvFactorRespUnpack(byte[] data) {
        int error = EncoderCanSpec.unpackIntBits(data, 0, 8);
        int factorInt = data[1] | data[2] << 8 | data[3] << 16 | data[4] << 24;
        float factor = Float.intBitsToFloat(factorInt);
        return new GetPositionConvFactorResp(error, factor);
    }

    public static GetVelocityConvFactor getVelocityConvFactorUnpack(byte[] data) {
        return new GetVelocityConvFactor();
    }

    public static GetVelocityConvFactorResp getVelocityConvFactorRespUnpack(byte[] data) {
        int error = EncoderCanSpec.unpackIntBits(data, 0, 8);
        int factorInt = data[1] | data[2] << 8 | data[3] << 16 | data[4] << 24;
        float factor = Float.intBitsToFloat(factorInt);
        return new GetVelocityConvFactorResp(error, factor);
    }

    public static GetAngleOffset getAngleOffsetUnpack(byte[] data) {
        return new GetAngleOffset();
    }

    public static GetAngleOffsetResp getAngleOffsetRespUnpack(byte[] data) {
        int error = EncoderCanSpec.unpackIntBits(data, 0, 8);
        int offsetInt = data[1] | data[2] << 8 | data[3] << 16 | data[4] << 24;
        float offset = Float.intBitsToFloat(offsetInt);
        return new GetAngleOffsetResp(error, offset);
    }

    public static GetVelocityAvgSamples getVelocityAvgSamplesUnpack(byte[] data) {
        return new GetVelocityAvgSamples();
    }

    public static GetVelocityAvgSamplesResp getVelocityAvgSamplesRespUnpack(byte[] data) {
        int error = EncoderCanSpec.unpackIntBits(data, 0, 8);
        int samples = EncoderCanSpec.unpackIntBits(data, 8, 16);
        return new GetVelocityAvgSamplesResp(error, samples);
    }

    public static SetCANID setCANIDUnpack(byte[] data) {
        int uniqueID = EncoderCanSpec.unpackIntBits(data, 0, 32);
        int cANID = EncoderCanSpec.unpackIntBits(data, 32, 8);
        return new SetCANID(uniqueID, cANID);
    }

    public static SetCANIDResp setCANIDRespUnpack(byte[] data) {
        int error = EncoderCanSpec.unpackIntBits(data, 0, 8);
        return new SetCANIDResp(error);
    }

    public static SetPeriodicFramePeriod setPeriodicFramePeriodUnpack(byte[] data) {
        int frameIdx = EncoderCanSpec.unpackIntBits(data, 0, 8);
        int period = EncoderCanSpec.unpackIntBits(data, 8, 16);
        return new SetPeriodicFramePeriod(frameIdx, period);
    }

    public static SetPeriodicFramePeriodResp setPeriodicFramePeriodRespUnpack(byte[] data) {
        int error = EncoderCanSpec.unpackIntBits(data, 0, 8);
        int frame = EncoderCanSpec.unpackIntBits(data, 8, 8);
        return new SetPeriodicFramePeriodResp(error, frame);
    }

    public static SetName setNameUnpack(byte[] data) {
        int index = EncoderCanSpec.unpackIntBits(data, 0, 8);
        int c3 = EncoderCanSpec.unpackIntBits(data, 8, 8);
        int c2 = EncoderCanSpec.unpackIntBits(data, 16, 8);
        int c1 = EncoderCanSpec.unpackIntBits(data, 24, 8);
        int c0 = EncoderCanSpec.unpackIntBits(data, 32, 8);
        int isEnd = EncoderCanSpec.unpackIntBits(data, 40, 8);
        return new SetName(index, c3, c2, c1, c0, isEnd);
    }

    public static SetNameResp setNameRespUnpack(byte[] data) {
        int error = EncoderCanSpec.unpackIntBits(data, 0, 8);
        int index = EncoderCanSpec.unpackIntBits(data, 8, 8);
        return new SetNameResp(error, index);
    }

    public static SetPositionConvFactor setPositionConvFactorUnpack(byte[] data) {
        int factorInt = data[0] | data[1] << 8 | data[2] << 16 | data[3] << 24;
        float factor = Float.intBitsToFloat(factorInt);
        return new SetPositionConvFactor(factor);
    }

    public static SetPositionConvFactorResp setPositionConvFactorRespUnpack(byte[] data) {
        int error = EncoderCanSpec.unpackIntBits(data, 0, 8);
        return new SetPositionConvFactorResp(error);
    }

    public static SetVelocityConvFactor setVelocityConvFactorUnpack(byte[] data) {
        int factorInt = data[0] | data[1] << 8 | data[2] << 16 | data[3] << 24;
        float factor = Float.intBitsToFloat(factorInt);
        return new SetVelocityConvFactor(factor);
    }

    public static SetVelocityConvFactorResp setVelocityConvFactorRespUnpack(byte[] data) {
        int error = EncoderCanSpec.unpackIntBits(data, 0, 8);
        return new SetVelocityConvFactorResp(error);
    }

    public static SetAngleOffset setAngleOffsetUnpack(byte[] data) {
        int offsetInt = data[0] | data[1] << 8 | data[2] << 16 | data[3] << 24;
        float offset = Float.intBitsToFloat(offsetInt);
        return new SetAngleOffset(offset);
    }

    public static SetAngleOffsetResp setAngleOffsetRespUnpack(byte[] data) {
        int error = EncoderCanSpec.unpackIntBits(data, 0, 8);
        return new SetAngleOffsetResp(error);
    }

    public static SetVelocityAvgSamples setVelocityAvgSamplesUnpack(byte[] data) {
        int samples = EncoderCanSpec.unpackIntBits(data, 0, 8);
        return new SetVelocityAvgSamples(samples);
    }

    public static SetVelocityAvgSamplesResp setVelocityAvgSamplesRespUnpack(byte[] data) {
        int error = EncoderCanSpec.unpackIntBits(data, 0, 8);
        return new SetVelocityAvgSamplesResp(error);
    }

    public static GetInversion getInversionUnpack(byte[] data) {
        return new GetInversion();
    }

    public static GetInversionResp getInversionRespUnpack(byte[] data) {
        int error = EncoderCanSpec.unpackIntBits(data, 0, 8);
        int inverted = EncoderCanSpec.unpackIntBits(data, 8, 8);
        return new GetInversionResp(error, inverted);
    }

    public static GetZeroCentered getZeroCenteredUnpack(byte[] data) {
        return new GetZeroCentered();
    }

    public static GetZeroCenteredResp getZeroCenteredRespUnpack(byte[] data) {
        int error = EncoderCanSpec.unpackIntBits(data, 0, 8);
        int centered = EncoderCanSpec.unpackIntBits(data, 8, 8);
        return new GetZeroCenteredResp(error, centered);
    }

    public static GetAbsAvgDepth getAbsAvgDepthUnpack(byte[] data) {
        return new GetAbsAvgDepth();
    }

    public static GetAbsAvgDepthResp getAbsAvgDepthRespUnpack(byte[] data) {
        int error = EncoderCanSpec.unpackIntBits(data, 0, 8);
        int depth = EncoderCanSpec.unpackIntBits(data, 8, 8);
        return new GetAbsAvgDepthResp(error, depth);
    }

    public static SetInversion setInversionUnpack(byte[] data) {
        int inverted = EncoderCanSpec.unpackIntBits(data, 0, 8);
        return new SetInversion(inverted);
    }

    public static SetInversionResp setInversionRespUnpack(byte[] data) {
        int error = EncoderCanSpec.unpackIntBits(data, 0, 8);
        return new SetInversionResp(error);
    }

    public static SetZeroCentered setZeroCenteredUnpack(byte[] data) {
        int centered = EncoderCanSpec.unpackIntBits(data, 0, 8);
        return new SetZeroCentered(centered);
    }

    public static SetZeroCenteredResp setZeroCenteredRespUnpack(byte[] data) {
        int error = EncoderCanSpec.unpackIntBits(data, 0, 8);
        return new SetZeroCenteredResp(error);
    }

    public static SetAbsAvgDepth setAbsAvgDepthUnpack(byte[] data) {
        int depth = EncoderCanSpec.unpackIntBits(data, 0, 8);
        return new SetAbsAvgDepth(depth);
    }

    public static SetAbsAvgDepthResp setAbsAvgDepthRespUnpack(byte[] data) {
        int error = EncoderCanSpec.unpackIntBits(data, 0, 8);
        return new SetAbsAvgDepthResp(error);
    }

    public static Identify identifyUnpack(byte[] data) {
        return new Identify();
    }

    public static SetEncoderPosition setEncoderPositionUnpack(byte[] data) {
        int positionInt = data[0] | data[1] << 8 | data[2] << 16 | data[3] << 24;
        float position = Float.intBitsToFloat(positionInt);
        return new SetEncoderPosition(position);
    }

    public static ClearFaults clearFaultsUnpack(byte[] data) {
        return new ClearFaults();
    }

    private static int unpackIntBits(byte[] data, int startBit, int length) {
        int result = 0;
        int currentByte = startBit / 8;
        int bitWithinByte = startBit % 8;
        for (int i = 0; i < length; ++i) {
            byte b = data[currentByte];
            int thisBit = (b & 1 << bitWithinByte) != 0 ? 1 : 0;
            result |= thisBit << i;
            if (++bitWithinByte != 8) continue;
            bitWithinByte = 0;
            ++currentByte;
        }
        return result;
    }

    private static long unpackLongBits(byte[] data, int startBit, int length) {
        long result = 0L;
        int currentByte = startBit / 8;
        int bitWithinByte = startBit % 8;
        for (int i = 0; i < length; ++i) {
            byte b = data[currentByte];
            long thisBit = (b & 1 << bitWithinByte) != 0 ? 1L : 0L;
            result |= thisBit << i;
            if (++bitWithinByte != 8) continue;
            bitWithinByte = 0;
            ++currentByte;
        }
        return result;
    }

    public static double bootloader0BLMajorDecode(int value) {
        return value * 1;
    }

    public static double bootloader0BLMinorDecode(int value) {
        return value * 1;
    }

    public static double bootloader0ProductIDDecode(int value) {
        return value * 1;
    }

    public static double bootloader0RsvdDecode(int value) {
        return value * 1;
    }

    public static double periodicFrame0DeviceModelDecode(int value) {
        return value * 1;
    }

    public static double periodicFrame1Rsvd1Decode(int value) {
        return value * 1;
    }

    public static double periodicFrame1StickyRsvd1Decode(int value) {
        return value * 1;
    }

    public static double periodicFrame2TimestampDecode(int value) {
        return value * 1;
    }

    public static double periodicFrame3TimestampDecode(int value) {
        return value * 1;
    }

    public static double periodicFrame4TimestampDecode(int value) {
        return value * 1;
    }

    public static double uniqueIDRespIDDecode(int value) {
        return value * 1;
    }

    public static double restoreDefaultsKeyDecode(int value) {
        return value * 1;
    }

    public static double restoreDefaultsRespErrorDecode(int value) {
        return value * 1;
    }

    public static double getProductIDRespIDDecode(int value) {
        return value * 1;
    }

    public static double getVersioningRespHWMinorDecode(int value) {
        return value * 1;
    }

    public static double getVersioningRespHWMajorDecode(int value) {
        return value * 1;
    }

    public static double getVersioningRespSWPreReleaseDecode(int value) {
        return value * 1;
    }

    public static double getVersioningRespSWFixDecode(int value) {
        return value * 1;
    }

    public static double getVersioningRespSWMinorDecode(int value) {
        return value * 1;
    }

    public static double getVersioningRespSWMajorDecode(int value) {
        return value * 1;
    }

    public static double getPeriodicFramePeriodFrameIdxDecode(int value) {
        return value * 1;
    }

    public static double getPeriodicFramePeriodRespErrorDecode(int value) {
        return value * 1;
    }

    public static double getPeriodicFramePeriodRespFrameIdxDecode(int value) {
        return value * 1;
    }

    public static double getPeriodicFramePeriodRespPeriodDecode(int value) {
        return value * 1;
    }

    public static double getNameRespErrorDecode(int value) {
        return value * 1;
    }

    public static double getNameRespIndexDecode(int value) {
        return value * 1;
    }

    public static double getNameRespC3Decode(int value) {
        return value * 1;
    }

    public static double getNameRespC2Decode(int value) {
        return value * 1;
    }

    public static double getNameRespC1Decode(int value) {
        return value * 1;
    }

    public static double getNameRespC0Decode(int value) {
        return value * 1;
    }

    public static double getNameRespIsEndDecode(int value) {
        return value * 1;
    }

    public static double getPositionConvFactorRespErrorDecode(int value) {
        return value * 1;
    }

    public static double getVelocityConvFactorRespErrorDecode(int value) {
        return value * 1;
    }

    public static double getAngleOffsetRespErrorDecode(int value) {
        return value * 1;
    }

    public static double getVelocityAvgSamplesRespErrorDecode(int value) {
        return value * 1;
    }

    public static double getVelocityAvgSamplesRespSamplesDecode(int value) {
        return value * 1;
    }

    public static double setCANIDUniqueIDDecode(int value) {
        return value * 1;
    }

    public static double setCANIDCANIDDecode(int value) {
        return value * 1;
    }

    public static double setCANIDRespErrorDecode(int value) {
        return value * 1;
    }

    public static double setPeriodicFramePeriodFrameIdxDecode(int value) {
        return value * 1;
    }

    public static double setPeriodicFramePeriodPeriodDecode(int value) {
        return value * 1;
    }

    public static double setPeriodicFramePeriodRespErrorDecode(int value) {
        return value * 1;
    }

    public static double setPeriodicFramePeriodRespFrameDecode(int value) {
        return value * 1;
    }

    public static double setNameIndexDecode(int value) {
        return value * 1;
    }

    public static double setNameC3Decode(int value) {
        return value * 1;
    }

    public static double setNameC2Decode(int value) {
        return value * 1;
    }

    public static double setNameC1Decode(int value) {
        return value * 1;
    }

    public static double setNameC0Decode(int value) {
        return value * 1;
    }

    public static double setNameIsEndDecode(int value) {
        return value * 1;
    }

    public static double setNameRespErrorDecode(int value) {
        return value * 1;
    }

    public static double setNameRespIndexDecode(int value) {
        return value * 1;
    }

    public static double setPositionConvFactorRespErrorDecode(int value) {
        return value * 1;
    }

    public static double setVelocityConvFactorRespErrorDecode(int value) {
        return value * 1;
    }

    public static double setAngleOffsetRespErrorDecode(int value) {
        return value * 1;
    }

    public static double setVelocityAvgSamplesSamplesDecode(int value) {
        return value * 1;
    }

    public static double setVelocityAvgSamplesRespErrorDecode(int value) {
        return value * 1;
    }

    public static double getInversionRespErrorDecode(int value) {
        return value * 1;
    }

    public static double getInversionRespInvertedDecode(int value) {
        return value * 1;
    }

    public static double getZeroCenteredRespErrorDecode(int value) {
        return value * 1;
    }

    public static double getZeroCenteredRespCenteredDecode(int value) {
        return value * 1;
    }

    public static double getAbsAvgDepthRespErrorDecode(int value) {
        return value * 1;
    }

    public static double getAbsAvgDepthRespDepthDecode(int value) {
        return value * 1;
    }

    public static double setInversionInvertedDecode(int value) {
        return value * 1;
    }

    public static double setInversionRespErrorDecode(int value) {
        return value * 1;
    }

    public static double setZeroCenteredCenteredDecode(int value) {
        return value * 1;
    }

    public static double setZeroCenteredRespErrorDecode(int value) {
        return value * 1;
    }

    public static double setAbsAvgDepthDepthDecode(int value) {
        return value * 1;
    }

    public static double setAbsAvgDepthRespErrorDecode(int value) {
        return value * 1;
    }

    public record Bootloader0(int bLMajor, int bLMinor, int productID, int rsvd) {
    }

    public record PeriodicFrame0(int deviceModel) {
    }

    public record PeriodicFrame1(boolean unexpected, boolean hasReset, boolean cANTX, boolean cANRX, boolean eEPROM, int rsvd1, boolean stickyUnexpected, boolean stickyHasReset, boolean stickyCANTX, boolean stickyCANRX, boolean stickyEEPROM, int stickyRsvd1) {
    }

    public record PeriodicFrame2(int timestamp, double angle) {
    }

    public record PeriodicFrame3(int timestamp, double position) {
    }

    public record PeriodicFrame4(int timestamp, double velocity) {
    }

    public record UniqueIDResp(int iD) {
    }

    public record GetUniqueIDs() {
    }

    public record RestoreDefaults(int key) {
    }

    public record RestoreDefaultsResp(int error) {
    }

    public record GetProductID() {
    }

    public record GetProductIDResp(int iD) {
    }

    public record GetVersioning() {
    }

    public record GetVersioningResp(int hWMinor, int hWMajor, int sWPreRelease, int sWFix, int sWMinor, int sWMajor) {
    }

    public record GetPeriodicFramePeriod(int frameIdx) {
    }

    public record GetPeriodicFramePeriodResp(int error, int frameIdx, int period) {
    }

    public record GetName() {
    }

    public record GetNameResp(int error, int index, int c3, int c2, int c1, int c0, int isEnd) {
    }

    public record GetPositionConvFactor() {
    }

    public record GetPositionConvFactorResp(int error, double factor) {
    }

    public record GetVelocityConvFactor() {
    }

    public record GetVelocityConvFactorResp(int error, double factor) {
    }

    public record GetAngleOffset() {
    }

    public record GetAngleOffsetResp(int error, double offset) {
    }

    public record GetVelocityAvgSamples() {
    }

    public record GetVelocityAvgSamplesResp(int error, int samples) {
    }

    public record SetCANID(int uniqueID, int cANID) {
    }

    public record SetCANIDResp(int error) {
    }

    public record SetPeriodicFramePeriod(int frameIdx, int period) {
    }

    public record SetPeriodicFramePeriodResp(int error, int frame) {
    }

    public record SetName(int index, int c3, int c2, int c1, int c0, int isEnd) {
    }

    public record SetNameResp(int error, int index) {
    }

    public record SetPositionConvFactor(double factor) {
    }

    public record SetPositionConvFactorResp(int error) {
    }

    public record SetVelocityConvFactor(double factor) {
    }

    public record SetVelocityConvFactorResp(int error) {
    }

    public record SetAngleOffset(double offset) {
    }

    public record SetAngleOffsetResp(int error) {
    }

    public record SetVelocityAvgSamples(int samples) {
    }

    public record SetVelocityAvgSamplesResp(int error) {
    }

    public record GetInversion() {
    }

    public record GetInversionResp(int error, int inverted) {
    }

    public record GetZeroCentered() {
    }

    public record GetZeroCenteredResp(int error, int centered) {
    }

    public record GetAbsAvgDepth() {
    }

    public record GetAbsAvgDepthResp(int error, int depth) {
    }

    public record SetInversion(int inverted) {
    }

    public record SetInversionResp(int error) {
    }

    public record SetZeroCentered(int centered) {
    }

    public record SetZeroCenteredResp(int error) {
    }

    public record SetAbsAvgDepth(int depth) {
    }

    public record SetAbsAvgDepthResp(int error) {
    }

    public record Identify() {
    }

    public record SetEncoderPosition(double position) {
    }

    public record ClearFaults() {
    }
}

