/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.devices;

import com.revrobotics.CanFrameUtils;
import com.revrobotics.PowerHubCanSpec;
import com.revrobotics.canbridge.CanBridge;
import com.revrobotics.canbridge.CanBus;
import com.revrobotics.canbridge.CanMessage;

public class PowerHub {
    private final int id;
    private final CanBridge bridge;
    private final CanBus bus;
    private final CanFrameUtils utils;
    private static final int NUM_ATTEMPTS = 3;

    public PowerHub(CanBridge bridge, CanBus bus, int id) {
        this.id = id;
        this.bridge = bridge;
        this.bus = bus;
        this.utils = new CanFrameUtils(bridge, bus);
    }

    public int getDeviceId() {
        return this.id;
    }

    public void setSwitchableChannel(boolean on) {
        byte[] data = new byte[]{(byte)(on ? 1 : 0)};
        CanMessage frame = CanMessage.createClassic((int)(134547520 + this.id), (byte[])data);
        this.bridge.sendMessage(this.bus, frame);
    }

    public void setCanId(int newId) {
        byte[] data = new byte[]{(byte)newId};
        CanMessage frame = CanMessage.createClassic((int)(134578048 + this.id), (byte[])data);
        this.bridge.sendMessage(this.bus, frame);
    }

    public void clearFaults() {
        byte[] data = new byte[]{};
        CanMessage frame = CanMessage.createClassic((int)(134552448 + this.id), (byte[])data);
        this.bridge.sendMessage(this.bus, frame);
    }

    public HardwareFaults getHardwareFaults() {
        for (int i = 0; i < 3; ++i) {
            HardwareFaults result = this.getHardwareFaultsOrNull();
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public HardwareFaults getHardwareFaultsOrNull() {
        byte[] data = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        CanMessage frame = CanMessage.createRtr((int)(134552384 + this.id), (byte[])data);
        CanMessage response = this.utils.sendAndAwaitResponse(frame, frame.messageId(), 500);
        if (response == null) {
            return null;
        }
        PowerHubCanSpec.GetHardwareFaults faults = PowerHubCanSpec.getHardwareFaultsUnpack(response.data());
        return new HardwareFaults(faults.aDCInit(), faults.cANInit(), faults.cANRx(), faults.cANSend(), faults.cANSetId(), faults.eEPROMRead(), faults.eEPROMWrite(), faults.cRCInit(), faults.dACInit(), faults.fDCANInit(), faults.i2CInit(), faults.sYSClockInit(), faults.sPIInit(), faults.timerInit(), faults.uSARTInit(), faults.cSAChannelInit(), faults.cSAChannelRead(), faults.cSAChannelInvalid());
    }

    public Status0 getStatus0() {
        CanMessage frame = this.bridge.getLatestMessage(this.bus, 134551552 + this.id, 0x1FFFFFFF);
        if (frame == null) {
            return null;
        }
        PowerHubCanSpec.Status0 unpacked = PowerHubCanSpec.status0Unpack(frame.data());
        return new Status0(PowerHubCanSpec.status0Channel0CurrentDecode(unpacked.channel0Current()), PowerHubCanSpec.status0Channel1CurrentDecode(unpacked.channel1Current()), PowerHubCanSpec.status0Channel2CurrentDecode(unpacked.channel2Current()), unpacked.channel0BreakerFault(), unpacked.channel1BreakerFault(), PowerHubCanSpec.status0Channel3CurrentDecode(unpacked.channel3Current()), PowerHubCanSpec.status0Channel4CurrentDecode(unpacked.channel4Current()), PowerHubCanSpec.status0Channel5CurrentDecode(unpacked.channel5Current()), unpacked.channel2BreakerFault(), unpacked.channel3BreakerFault());
    }

    public Status1 getStatus1() {
        CanMessage frame = this.bridge.getLatestMessage(this.bus, 134551616 + this.id, 0x1FFFFFFF);
        if (frame == null) {
            return null;
        }
        PowerHubCanSpec.Status1 unpacked = PowerHubCanSpec.status1Unpack(frame.data());
        return new Status1(PowerHubCanSpec.status1Channel6CurrentDecode(unpacked.channel6Current()), PowerHubCanSpec.status1Channel7CurrentDecode(unpacked.channel7Current()), PowerHubCanSpec.status1Channel8CurrentDecode(unpacked.channel8Current()), unpacked.channel4BreakerFault(), unpacked.channel5BreakerFault(), PowerHubCanSpec.status1Channel9CurrentDecode(unpacked.channel9Current()), PowerHubCanSpec.status1Channel10CurrentDecode(unpacked.channel10Current()), PowerHubCanSpec.status1Channel11CurrentDecode(unpacked.channel11Current()), unpacked.channel6BreakerFault(), unpacked.channel7BreakerFault());
    }

    public Status2 getStatus2() {
        CanMessage frame = this.bridge.getLatestMessage(this.bus, 134551680 + this.id, 0x1FFFFFFF);
        if (frame == null) {
            return null;
        }
        PowerHubCanSpec.Status2 unpacked = PowerHubCanSpec.status2Unpack(frame.data());
        return new Status2(PowerHubCanSpec.status2Channel12CurrentDecode(unpacked.channel12Current()), PowerHubCanSpec.status2Channel13CurrentDecode(unpacked.channel13Current()), PowerHubCanSpec.status2Channel14CurrentDecode(unpacked.channel14Current()), unpacked.channel8BreakerFault(), unpacked.channel9BreakerFault(), PowerHubCanSpec.status2Channel15CurrentDecode(unpacked.channel15Current()), PowerHubCanSpec.status2Channel16CurrentDecode(unpacked.channel16Current()), PowerHubCanSpec.status2Channel17CurrentDecode(unpacked.channel17Current()), unpacked.channel10BreakerFault(), unpacked.channel11BreakerFault());
    }

    public Status3 getStatus3() {
        CanMessage frame = this.bridge.getLatestMessage(this.bus, 134551744 + this.id, 0x1FFFFFFF);
        if (frame == null) {
            return null;
        }
        PowerHubCanSpec.Status3 unpacked = PowerHubCanSpec.status3Unpack(frame.data());
        return new Status3(PowerHubCanSpec.status3Channel18CurrentDecode(unpacked.channel18Current()), PowerHubCanSpec.status3Channel19CurrentDecode(unpacked.channel19Current()), unpacked.channel12BreakerFault(), unpacked.channel13BreakerFault(), unpacked.channel14BreakerFault(), unpacked.channel15BreakerFault(), PowerHubCanSpec.status3Channel20CurrentDecode(unpacked.channel20Current()), PowerHubCanSpec.status3Channel21CurrentDecode(unpacked.channel21Current()), PowerHubCanSpec.status3Channel22CurrentDecode(unpacked.channel22Current()), PowerHubCanSpec.status3Channel23CurrentDecode(unpacked.channel23Current()), unpacked.channel16BreakerFault(), unpacked.channel17BreakerFault(), unpacked.channel18BreakerFault(), unpacked.channel19BreakerFault(), unpacked.channel20BreakerFault(), unpacked.channel21BreakerFault(), unpacked.channel22BreakerFault(), unpacked.channel23BreakerFault());
    }

    public Status4 getStatus4() {
        CanMessage frame = this.bridge.getLatestMessage(this.bus, 134551808 + this.id, 0x1FFFFFFF);
        if (frame == null) {
            return null;
        }
        PowerHubCanSpec.Status4 unpacked = PowerHubCanSpec.status4Unpack(frame.data());
        return new Status4(PowerHubCanSpec.status4VbusDecode(unpacked.vbus()), unpacked.enabled(), unpacked.roboRioPresent(), 0, unpacked.brownoutFault(), false, unpacked.cANWarning(), unpacked.hardwareFault(), unpacked.switchableChannelState(), unpacked.stickyBrownoutFault(), false, unpacked.stickyCANWarning(), unpacked.stickyBusOffFault(), unpacked.stickyHardwareFault(), unpacked.stickyFirmwareFault(), unpacked.stickyChannel20BreakerFault(), unpacked.stickyChannel21BreakerFault(), unpacked.stickyChannel22BreakerFault(), unpacked.stickyChannel23BreakerFault(), unpacked.stickyResetFault(), PowerHubCanSpec.status4TotalCurrentDecode(unpacked.totalCurrent()), unpacked.stickyChannel0BreakerFault(), unpacked.stickyChannel1BreakerFault(), unpacked.stickyChannel2BreakerFault(), unpacked.stickyChannel3BreakerFault(), unpacked.stickyChannel4BreakerFault(), unpacked.stickyChannel5BreakerFault(), unpacked.stickyChannel6BreakerFault(), unpacked.stickyChannel7BreakerFault(), unpacked.stickyChannel8BreakerFault(), unpacked.stickyChannel9BreakerFault(), unpacked.stickyChannel10BreakerFault(), unpacked.stickyChannel11BreakerFault(), unpacked.stickyChannel12BreakerFault(), unpacked.stickyChannel13BreakerFault(), unpacked.stickyChannel14BreakerFault(), unpacked.stickyChannel15BreakerFault(), unpacked.stickyChannel16BreakerFault(), unpacked.stickyChannel17BreakerFault(), unpacked.stickyChannel18BreakerFault(), unpacked.stickyChannel19BreakerFault(), 0);
    }

    public void identify() {
        byte[] data = new byte[]{};
        CanMessage message = CanMessage.createClassic((int)(134552960 + this.id), (byte[])data);
        this.bridge.sendMessage(this.bus, message);
    }

    private Version getVersionOrNull() {
        byte[] data = new byte[8];
        CanMessage message = CanMessage.createRtr((int)(134555136 + this.id), (byte[])data);
        CanMessage response = this.utils.sendAndAwaitResponse(message, message.messageId(), 1000);
        if (response == null) {
            return null;
        }
        PowerHubCanSpec.GetVersion version = PowerHubCanSpec.getVersionUnpack(response.data());
        return new Version(version.firmwareYear(), version.firmwareMinor(), version.firmwareFix(), 0);
    }

    public Version getVersion() {
        for (int i = 0; i < 3; ++i) {
            Version version = this.getVersionOrNull();
            if (version == null) continue;
            return version;
        }
        return null;
    }

    public static boolean checkIfUsbBridge(CanBridge bridge, CanBus bus, int deviceId) {
        CanFrameUtils utils = new CanFrameUtils(bridge, bus);
        byte[] data = new byte[0];
        CanMessage message = CanMessage.createRtr((int)(134556864 + deviceId), (byte[])data);
        CanMessage response = utils.sendAndAwaitResponse(message, message.messageId(), 500);
        return response != null && response.data().length == 4;
    }

    public void enterDfuBootloader() {
        int messageId = 134579072 + this.id;
        byte[] data = new byte[]{17, -33, -83, 16};
        CanMessage message = CanMessage.createClassic((int)messageId, (byte[])data);
        for (int i = 0; i < 3; ++i) {
            this.bridge.sendMessage(this.bus, message);
        }
    }

    public record HardwareFaults(boolean adcInit, boolean canInit, boolean canRx, boolean canSend, boolean canSetId, boolean eepromRead, boolean eepromWrite, boolean crcInit, boolean dacInit, boolean fdcanInit, boolean i2cInit, boolean sysClockInit, boolean spiInit, boolean timerInit, boolean usartInit, boolean csaChannelInit, boolean csaChannelRead, boolean csaChannelInvalid) {
    }

    public record Status0(double channel0Current, double channel1Current, double channel2Current, boolean channel0BreakerFault, boolean channel1BreakerFault, double channel3Current, double channel4Current, double channel5Current, boolean channel2BreakerFault, boolean channel3BreakerFault) {
    }

    public record Status1(double channel6Current, double channel7Current, double channel8Current, boolean channel4BreakerFault, boolean channel5BreakerFault, double channel9Current, double channel10Current, double channel11Current, boolean channel6BreakerFault, boolean channel7BreakerFault) {
    }

    public record Status2(double channel12Current, double channel13Current, double channel14Current, boolean channel8BreakerFault, boolean channel9BreakerFault, double channel15Current, double channel16Current, double channel17Current, boolean channel10BreakerFault, boolean channel11BreakerFault) {
    }

    public record Status3(double channel18Current, double channel19Current, boolean channel12BreakerFault, boolean channel13BreakerFault, boolean channel14BreakerFault, boolean channel15BreakerFault, double channel20Current, double channel21Current, double channel22Current, double channel23Current, boolean channel16BreakerFault, boolean channel17BreakerFault, boolean channel18BreakerFault, boolean channel19BreakerFault, boolean channel20BreakerFault, boolean channel21BreakerFault, boolean channel22BreakerFault, boolean channel23BreakerFault) {
    }

    public record Status4(double vbus, boolean enabled, boolean roboRioPresent, int reserved0, boolean brownoutFault, boolean reserved1, boolean cANWarning, boolean hardwareFault, boolean switchableChannelState, boolean stickyBrownoutFault, boolean reserved2, boolean stickyCANWarning, boolean stickyBusOffFault, boolean stickyHardwareFault, boolean stickyFirmwareFault, boolean stickyChannel20BreakerFault, boolean stickyChannel21BreakerFault, boolean stickyChannel22BreakerFault, boolean stickyChannel23BreakerFault, boolean stickyResetFault, double totalCurrent, boolean stickyChannel0BreakerFault, boolean stickyChannel1BreakerFault, boolean stickyChannel2BreakerFault, boolean stickyChannel3BreakerFault, boolean stickyChannel4BreakerFault, boolean stickyChannel5BreakerFault, boolean stickyChannel6BreakerFault, boolean stickyChannel7BreakerFault, boolean stickyChannel8BreakerFault, boolean stickyChannel9BreakerFault, boolean stickyChannel10BreakerFault, boolean stickyChannel11BreakerFault, boolean stickyChannel12BreakerFault, boolean stickyChannel13BreakerFault, boolean stickyChannel14BreakerFault, boolean stickyChannel15BreakerFault, boolean stickyChannel16BreakerFault, boolean stickyChannel17BreakerFault, boolean stickyChannel18BreakerFault, boolean stickyChannel19BreakerFault, int reserved3) {
    }

    public record Version(int major, int minor, int fix, int prerelease) {
    }
}

