/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.canbridge.slcan;

import com.fazecast.jSerialComm.SerialPort;
import com.revrobotics.canbridge.CanBridge;
import com.revrobotics.canbridge.CanBridgeCallback;
import com.revrobotics.canbridge.CanBus;
import com.revrobotics.canbridge.CanMessage;
import com.revrobotics.canbridge.slcan.SLCanContext;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SLCanBridge
implements CanBridge {
    private final ArrayList<SLCanContext> contexts = new ArrayList();
    private static final List<String> REV_DEVICES = List.of("Flex Motor Controller", "SPARK MAX Motor Controller", "REV Hub Device", "REV Hub Bootloader");
    private final Path tracingDirectory;
    private final List<CanBridgeCallback> callbacks = new ArrayList<CanBridgeCallback>();

    public SLCanBridge(Path tracingDirectory) {
        this.tracingDirectory = tracingDirectory;
    }

    @Override
    public int scanForBuses() {
        SerialPort[] ports = SerialPort.getCommPorts();
        ports = (SerialPort[])Arrays.stream(ports).filter(this::isRevDevice).toArray(SerialPort[]::new);
        ArrayList<SLCanContext> contextsToRemove = new ArrayList<SLCanContext>();
        for (SLCanContext context2 : this.contexts) {
            if (!Arrays.stream(ports).noneMatch(port -> context2.isOpen() && port.getSystemPortName().equals(context2.getDescriptor()))) continue;
            contextsToRemove.add(context2);
            this.onCloseCallback();
        }
        this.contexts.removeAll(contextsToRemove);
        for (SerialPort port2 : ports) {
            SLCanContext newContext;
            boolean success;
            if (!this.contexts.stream().noneMatch(context -> context.getDescriptor().equals(port2.getSystemPortName())) || !(success = (newContext = new SLCanContext(port2, this.toCanBus(port2), this.tracingDirectory)).start())) continue;
            this.contexts.add(newContext);
            this.onOpenCallback();
        }
        return this.contexts.size();
    }

    @Override
    public CanBus[] getBuses() {
        return (CanBus[])this.contexts.stream().map(SLCanContext::getBus).toArray(CanBus[]::new);
    }

    @Override
    public CanBus getBusOrNull(String descriptor) {
        for (SLCanContext context : this.contexts) {
            CanBus bus = context.getBus();
            if (!bus.descriptor().equals(descriptor)) continue;
            return bus;
        }
        return null;
    }

    public void openPorts() {
        for (SLCanContext context : this.contexts) {
            context.sendOpenCommand();
        }
    }

    @Override
    public CanMessage getLatestMessage(CanBus bus, int messageId, int mask) {
        SLCanContext context = this.getContextOrNull(bus);
        if (context == null) {
            return null;
        }
        return context.getLastMessage(messageId, mask);
    }

    @Override
    public CanMessage[] getLatestMessages(CanBus bus, int maxAgeMs) {
        SLCanContext context = this.getContextOrNull(bus);
        if (context == null) {
            return null;
        }
        return context.getLatestMessages(maxAgeMs);
    }

    @Override
    public void sendMessage(CanBus bus, CanMessage message, int periodMs) {
        SLCanContext context = this.getContextOrNull(bus);
        if (context == null) {
            return;
        }
        context.sendMessage(message, periodMs);
    }

    @Override
    public CanBridgeCallback addCallback(CanBridgeCallback callback) {
        this.callbacks.add(callback);
        return callback;
    }

    @Override
    public void removeCallback(CanBridgeCallback callback) {
        this.callbacks.remove(callback);
    }

    private void onOpenCallback() {
        try {
            for (CanBridgeCallback callback : this.callbacks) {
                callback.onBridgeOpen();
            }
        }
        catch (Exception e) {
            System.err.println("Error while notifying CAN Bridge callbacks:\n" + e.getMessage());
        }
    }

    private void onCloseCallback() {
        try {
            for (CanBridgeCallback callback : this.callbacks) {
                callback.onBridgeClose();
            }
        }
        catch (Exception e) {
            System.err.println("Error while notifying CAN Bridge callbacks:\n" + e.getMessage());
        }
    }

    private CanBus toCanBus(SerialPort port) {
        return new CanBus(port.getSystemPortName(), 1L);
    }

    private boolean isRevDevice(SerialPort port) {
        return REV_DEVICES.contains(port.getPortDescription());
    }

    private SLCanContext getContextOrNull(CanBus bus) {
        for (SLCanContext context : this.contexts) {
            if (bus == null || !context.getDescriptor().equals(bus.descriptor())) continue;
            return context;
        }
        return null;
    }
}

