/*
 * Decompiled with CFR 0.152.
 */
package io.github.wimdeblauwe.htmx.spring.boot.mvc;

import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxRequestHeader;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HtmxTriggerHeadersRequestCondition;
import io.github.wimdeblauwe.htmx.spring.boot.mvc.HxRequest;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.mvc.condition.CompositeRequestCondition;
import org.springframework.web.servlet.mvc.condition.HeadersRequestCondition;
import org.springframework.web.servlet.mvc.condition.RequestCondition;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class HtmxRequestMappingHandlerMapping
extends RequestMappingHandlerMapping {
    protected RequestCondition<?> getCustomMethodCondition(Method method) {
        HxRequest methodAnnotation = (HxRequest)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, HxRequest.class);
        return this.createCondition(methodAnnotation);
    }

    protected RequestCondition<?> getCustomTypeCondition(Class<?> handlerType) {
        HxRequest typeAnnotation = (HxRequest)AnnotatedElementUtils.findMergedAnnotation(handlerType, HxRequest.class);
        return this.createCondition(typeAnnotation);
    }

    private RequestCondition<?> createCondition(HxRequest hxRequest) {
        if (hxRequest == null) {
            return null;
        }
        ArrayList<Object> conditions = new ArrayList<Object>();
        conditions.add(new HeadersRequestCondition(new String[]{HtmxRequestHeader.HX_REQUEST.getValue()}));
        if (StringUtils.hasText((String)hxRequest.value())) {
            conditions.add(new HtmxTriggerHeadersRequestCondition(hxRequest.value()));
        } else {
            if (StringUtils.hasText((String)hxRequest.triggerId())) {
                conditions.add(new HeadersRequestCondition(new String[]{HtmxRequestHeader.HX_TRIGGER.getValue() + "=" + hxRequest.triggerId()}));
            }
            if (StringUtils.hasText((String)hxRequest.triggerName())) {
                conditions.add(new HeadersRequestCondition(new String[]{HtmxRequestHeader.HX_TRIGGER_NAME.getValue() + "=" + hxRequest.triggerName()}));
            }
        }
        if (StringUtils.hasText((String)hxRequest.target())) {
            conditions.add(new HeadersRequestCondition(new String[]{HtmxRequestHeader.HX_TARGET.getValue() + "=" + hxRequest.target()}));
        }
        if (!hxRequest.boosted()) {
            conditions.add(new HeadersRequestCondition(new String[]{"!" + HtmxRequestHeader.HX_BOOSTED.getValue()}));
        }
        if (!hxRequest.historyRestoreRequest()) {
            conditions.add(new HeadersRequestCondition(new String[]{"!" + HtmxRequestHeader.HX_HISTORY_RESTORE_REQUEST.getValue()}));
        }
        return new CompositeRequestCondition((RequestCondition[])conditions.toArray(RequestCondition[]::new));
    }
}

