/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.namedparam;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.jdbc.core.SqlParameterValue;
import org.springframework.jdbc.core.namedparam.AbstractSqlParameterSource;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public abstract class SqlParameterSourceUtils {
    public static SqlParameterSource[] createBatch(Object ... candidates) {
        return SqlParameterSourceUtils.createBatch(Arrays.asList(candidates));
    }

    public static SqlParameterSource[] createBatch(Collection<?> candidates) {
        SqlParameterSource[] batch = new SqlParameterSource[candidates.size()];
        int i = 0;
        for (Object candidate : candidates) {
            AbstractSqlParameterSource abstractSqlParameterSource;
            if (candidate instanceof Map) {
                Map map = (Map)candidate;
                abstractSqlParameterSource = new MapSqlParameterSource(map);
            } else {
                abstractSqlParameterSource = new BeanPropertySqlParameterSource(candidate);
            }
            batch[i] = abstractSqlParameterSource;
            ++i;
        }
        return batch;
    }

    public static SqlParameterSource[] createBatch(Map<String, ?>[] valueMaps) {
        SqlParameterSource[] batch = new SqlParameterSource[valueMaps.length];
        for (int i = 0; i < valueMaps.length; ++i) {
            batch[i] = new MapSqlParameterSource(valueMaps[i]);
        }
        return batch;
    }

    public static @Nullable Object getTypedValue(SqlParameterSource source, String parameterName) {
        int sqlType = source.getSqlType(parameterName);
        if (sqlType != Integer.MIN_VALUE) {
            return new SqlParameterValue(sqlType, source.getTypeName(parameterName), source.getValue(parameterName));
        }
        return source.getValue(parameterName);
    }

    public static Map<String, String> extractCaseInsensitiveParameterNames(SqlParameterSource parameterSource) {
        HashMap<String, String> caseInsensitiveParameterNames = new HashMap<String, String>();
        String[] paramNames = parameterSource.getParameterNames();
        if (paramNames != null) {
            for (String name : paramNames) {
                caseInsensitiveParameterNames.put(name.toLowerCase(Locale.ROOT), name);
            }
        }
        return caseInsensitiveParameterNames;
    }
}

