/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.device.detection.dfu;

import java.beans.Transient;

public record DfuDevice(int pid, int vid, int version, int devNum, int cfg, int intf, int alt, String serial) {
    private static final int ST_VENDOR_ID = 1155;
    private static final int ST_DFU_PRODUCT_ID = 57105;

    public static DfuDevice parse(String dfuUtilOutput) {
        try {
            String pidVidString = DfuDevice.pidVidPortion(dfuUtilOutput);
            int vid = Integer.parseInt(pidVidString.substring(0, pidVidString.indexOf(":")), 16);
            int pid = Integer.parseInt(pidVidString.substring(pidVidString.indexOf(":") + 1), 16);
            int version = DfuDevice.parseIntParam(dfuUtilOutput, "ver");
            int devNum = DfuDevice.parseIntParam(dfuUtilOutput, "devnum");
            int cfg = DfuDevice.parseIntParam(dfuUtilOutput, "cfg");
            int intf = DfuDevice.parseIntParam(dfuUtilOutput, "intf");
            int alt = DfuDevice.parseIntParam(dfuUtilOutput, "alt");
            String serial = DfuDevice.parseStringParam(dfuUtilOutput, "serial").replace("\"", "").replace("\r", "");
            return new DfuDevice(pid, vid, version, devNum, cfg, intf, alt, serial);
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            return null;
        }
    }

    private static int parseIntParam(String text, String key) {
        String value = DfuDevice.parseStringParam(text, key);
        return Integer.parseInt(value);
    }

    private static String parseStringParam(String text, String key) {
        String postKey = text.substring(text.indexOf(key));
        String postEquals = postKey.substring(postKey.indexOf(61) + 1);
        if (postEquals.contains(",")) {
            return postEquals.substring(0, postEquals.indexOf(","));
        }
        return postEquals;
    }

    private static String pidVidPortion(String text) {
        return text.substring(text.indexOf("[") + 1, text.indexOf("]"));
    }

    @Transient
    public boolean isSTDevice() {
        return this.pid == 57105 && this.vid == 1155;
    }
}

