/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.device.detection.dfu;

import com.revrobotics.device.detection.dfu.DfuDevice;
import com.revrobotics.device.detection.dfu.DfuManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public record ExecutableDfuManager(Path baseDirectory) implements DfuManager
{
    private static final Logger logger = Logger.getLogger(ExecutableDfuManager.class.getName());
    private static Path dfuExecutable;

    private static String getDfuUtilFullName() {
        String name = System.getProperty("os.name");
        if (name.toLowerCase().contains("windows")) {
            return "dfu-util.exe";
        }
        if (name.toLowerCase().contains("mac")) {
            String arch = System.getProperty("os.arch");
            if ("aarch64".equals(arch)) {
                return "dfu-util-mac-arm64";
            }
            if ("amd64".equals(arch)) {
                return "dfu-util-mac-x64";
            }
            throw new IllegalStateException("Unsupported mac arch " + arch);
        }
        if (name.toLowerCase().contains("linux")) {
            return "dfu-util-linux";
        }
        throw new RuntimeException("Unknown OS: " + name);
    }

    private static void makeExecutable(Path path) {
        try {
            HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>();
            permissions.add(PosixFilePermission.OWNER_EXECUTE);
            Files.setPosixFilePermissions(path, permissions);
        }
        catch (IOException | UnsupportedOperationException e) {
            logger.log(Level.SEVERE, "Unable to make dfu file executable");
        }
        boolean result = path.toFile().setExecutable(true);
        logger.info("Set executable result: " + result + ", is executable: " + Files.isExecutable(path));
    }

    private Path findDfuExecutable() {
        if (dfuExecutable != null) {
            return dfuExecutable;
        }
        String appDir = System.getProperty("app.dir");
        String dfuUtilFullName = ExecutableDfuManager.getDfuUtilFullName();
        if (appDir != null) {
            System.err.println("App dir: " + appDir);
            dfuExecutable = Path.of(appDir, new String[0]).resolve("..").resolve("bin").resolve(dfuUtilFullName);
            return dfuExecutable;
        }
        Path unbundledDir = Path.of(".", new String[0]).toAbsolutePath().normalize();
        if (unbundledDir.getFileName().toString().equals("server")) {
            dfuExecutable = unbundledDir.resolve("unbundled-exe").resolve(dfuUtilFullName).toAbsolutePath();
            return dfuExecutable;
        }
        throw new IllegalStateException("Unable to find Dfu executable");
    }

    private String runDfu(String command) {
        this.findDfuExecutable();
        ArrayList<String> splitCommand = new ArrayList<String>();
        splitCommand.add(dfuExecutable.toString());
        splitCommand.addAll(List.of(command.split(" ")));
        ProcessBuilder processBuilder = new ProcessBuilder(splitCommand);
        try {
            Process process = processBuilder.start();
            int result = process.waitFor();
            if (result != 0) {
                logger.log(Level.SEVERE, "Failed to run dfu-util: " + result);
                String errorText = ExecutableDfuManager.readOutputStream(process, false);
                logger.log(Level.SEVERE, errorText);
            }
            return ExecutableDfuManager.readOutputStream(process, true);
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private static String readOutputStream(Process process, boolean stdout) throws IOException {
        String line;
        InputStream stream = stdout ? process.getInputStream() : process.getErrorStream();
        BufferedReader errorReader = new BufferedReader(new InputStreamReader(stream));
        StringBuilder builder = new StringBuilder();
        while ((line = errorReader.readLine()) != null) {
            builder.append(line);
            builder.append(System.lineSeparator());
        }
        return builder.toString();
    }

    @Override
    public List<DfuDevice> listDevices() {
        String fullText = this.runDfu("--list");
        ArrayList<DfuDevice> devices = new ArrayList<DfuDevice>();
        for (String line : fullText.split("\n")) {
            DfuDevice device = DfuDevice.parse(line);
            if (device == null || device.version() <= 0 || !device.isSTDevice()) continue;
            devices.add(device);
        }
        return devices;
    }

    @Override
    public void flashDevice(DfuDevice device, Path dfuPath, boolean leave) {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.findDfuExecutable().toString());
        command.addAll(List.of("--serial", device.serial(), "-a", String.valueOf(device.alt()), "-D", dfuPath.toString()));
        if (leave) {
            command.add("-s");
            command.add(":leave");
        }
        logger.log(Level.INFO, String.join((CharSequence)" ", command));
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        processBuilder.inheritIO();
        try {
            Process process = processBuilder.start();
            int result = process.waitFor();
            logger.log(Level.INFO, "Dfu flash result: " + result);
            String output = ExecutableDfuManager.readOutputStream(process, true);
            logger.log(Level.INFO, output);
            output = ExecutableDfuManager.readOutputStream(process, false);
            logger.log(Level.INFO, output);
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public Path downloadDfu() {
        String url = "https://github.com/REVrobotics/REV-Software-Binaries/releases/download/sf-25.0.4/spark_flex_25_0_4.dfu";
        try {
            Path dfuPath = Files.createTempFile("spark-flex-25-0-4", ".dfu", new FileAttribute[0]);
            Files.copy(new URI(url).toURL().openStream(), dfuPath, StandardCopyOption.REPLACE_EXISTING);
            return dfuPath;
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

