/*
 * Decompiled with CFR 0.152.
 */
package com.revrobotics.spark;

import com.revrobotics.REVLibError;
import com.revrobotics.jni.CANSparkJNI;
import com.revrobotics.spark.ClosedLoopSlot;
import com.revrobotics.spark.SparkBase;

public class SparkClosedLoopController {
    private final SparkBase spark;
    private SparkBase.ControlType controlType;

    SparkClosedLoopController(SparkBase device) {
        this.spark = device;
        this.controlType = SparkBase.ControlType.kDutyCycle;
    }

    public REVLibError setSetpoint(double setpoint, SparkBase.ControlType ctrl) {
        this.spark.throwIfClosed();
        this.controlType = ctrl;
        return this.setSetpoint(setpoint, ctrl, ClosedLoopSlot.kSlot0);
    }

    public REVLibError setSetpoint(double setpoint, SparkBase.ControlType ctrl, ClosedLoopSlot slot) {
        this.spark.throwIfClosed();
        return this.setSetpoint(setpoint, ctrl, slot, 0.0);
    }

    public REVLibError setSetpoint(double setpoint, SparkBase.ControlType ctrl, ClosedLoopSlot slot, double arbFeedforward) {
        this.spark.throwIfClosed();
        return this.spark.setpointCommand(setpoint, ctrl, slot.value, arbFeedforward);
    }

    public REVLibError setSetpoint(double setpoint, SparkBase.ControlType ctrl, ClosedLoopSlot slot, double arbFeedforward, ArbFFUnits arbFFUnits) {
        this.spark.throwIfClosed();
        return this.spark.setpointCommand(setpoint, ctrl, slot.value, arbFeedforward, arbFFUnits.value);
    }

    @Deprecated(forRemoval=true)
    public REVLibError setReference(double setpoint, SparkBase.ControlType ctrl) {
        return this.setSetpoint(setpoint, ctrl);
    }

    @Deprecated(forRemoval=true)
    public REVLibError setReference(double setpoint, SparkBase.ControlType ctrl, ClosedLoopSlot slot) {
        return this.setSetpoint(setpoint, ctrl, slot);
    }

    @Deprecated(forRemoval=true)
    public REVLibError setReference(double setpoint, SparkBase.ControlType ctrl, ClosedLoopSlot slot, double arbFeedforward) {
        return this.setSetpoint(setpoint, ctrl, slot, arbFeedforward);
    }

    @Deprecated(forRemoval=true)
    public REVLibError setReference(double setpoint, SparkBase.ControlType ctrl, ClosedLoopSlot slot, double arbFeedforward, ArbFFUnits arbFFUnits) {
        return this.setSetpoint(setpoint, ctrl, slot, arbFeedforward, arbFFUnits);
    }

    public SparkBase.ControlType getControlType() {
        this.spark.throwIfClosed();
        return this.controlType;
    }

    public REVLibError setIAccum(double iAccum) {
        this.spark.throwIfClosed();
        return REVLibError.fromInt(CANSparkJNI.c_Spark_SetIAccum(this.spark.sparkHandle, (float)iAccum));
    }

    public double getIAccum() {
        this.spark.throwIfClosed();
        return CANSparkJNI.c_Spark_GetIAccum(this.spark.sparkHandle);
    }

    public double getSetpoint() {
        this.spark.throwIfClosed();
        return CANSparkJNI.c_Spark_GetSetpoint(this.spark.sparkHandle);
    }

    public boolean isAtSetpoint() {
        this.spark.throwIfClosed();
        return CANSparkJNI.c_Spark_IsAtSetpoint(this.spark.sparkHandle);
    }

    public ClosedLoopSlot getSelectedSlot() {
        this.spark.throwIfClosed();
        return ClosedLoopSlot.fromInt(CANSparkJNI.c_Spark_GetSelectedSlot(this.spark.sparkHandle));
    }

    public double getMAXMotionSetpointPosition() {
        this.spark.throwIfClosed();
        return CANSparkJNI.c_Spark_GetMaxMotionSetpointPosition(this.spark.sparkHandle);
    }

    public double getMAXMotionSetpointVelocity() {
        this.spark.throwIfClosed();
        return CANSparkJNI.c_Spark_GetMaxMotionSetpointVelocity(this.spark.sparkHandle);
    }

    public static enum ArbFFUnits {
        kVoltage(0),
        kPercentOut(1);

        public final int value;

        private ArbFFUnits(int value) {
            this.value = value;
        }

        public static ArbFFUnits fromInt(int value) {
            switch (value) {
                case 0: {
                    return kVoltage;
                }
                case 1: {
                    return kPercentOut;
                }
            }
            return kVoltage;
        }
    }
}

