/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.providers;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springdoc.core.versions.SpringDocApiVersionType;
import org.springdoc.core.versions.SpringDocVersionStrategy;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.CollectionUtils;

public abstract class SpringWebProvider
implements ApplicationContextAware {
    protected static final Logger LOGGER = LoggerFactory.getLogger(SpringWebProvider.class);
    protected ApplicationContext applicationContext;
    protected Map handlerMethods;
    protected final Map<SpringDocApiVersionType, SpringDocVersionStrategy> springDocVersionStrategyMap = new HashMap<SpringDocApiVersionType, SpringDocVersionStrategy>();

    public abstract Map getHandlerMethods();

    public abstract String findPathPrefix(SpringDocConfigProperties var1);

    public abstract Set<String> getActivePatterns(Object var1);

    public SpringDocVersionStrategy getSpringDocVersionStrategy(String version, String[] params) {
        SpringDocVersionStrategy springDocVersionStrategy = null;
        if (!CollectionUtils.isEmpty(this.springDocVersionStrategyMap)) {
            springDocVersionStrategy = this.springDocVersionStrategyMap.size() == 1 ? this.springDocVersionStrategyMap.values().iterator().next() : this.resolveApiVersionStrategy(version, params);
            springDocVersionStrategy.updateVersion(version, params);
        }
        return springDocVersionStrategy;
    }

    private SpringDocVersionStrategy resolveApiVersionStrategy(String version, String[] params) {
        if (version != null) {
            if (this.springDocVersionStrategyMap.containsKey((Object)SpringDocApiVersionType.PATH)) {
                return this.springDocVersionStrategyMap.get((Object)SpringDocApiVersionType.PATH);
            }
            if (this.springDocVersionStrategyMap.containsKey((Object)SpringDocApiVersionType.HEADER)) {
                return this.springDocVersionStrategyMap.get((Object)SpringDocApiVersionType.HEADER);
            }
            if (this.springDocVersionStrategyMap.containsKey((Object)SpringDocApiVersionType.MEDIA_TYPE)) {
                return this.springDocVersionStrategyMap.get((Object)SpringDocApiVersionType.MEDIA_TYPE);
            }
        }
        if (ArrayUtils.isNotEmpty((Object[])params) && this.springDocVersionStrategyMap.containsKey((Object)SpringDocApiVersionType.QUERY_PARAM)) {
            return this.springDocVersionStrategyMap.get((Object)SpringDocApiVersionType.QUERY_PARAM);
        }
        return this.springDocVersionStrategyMap.values().iterator().next();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

