/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.internal;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.SingularAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import org.hibernate.LockMode;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.MappingMetamodel;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.SingularAttributeMapping;
import org.hibernate.metamodel.mapping.internal.DiscriminatedAssociationAttributeMapping;
import org.hibernate.metamodel.mapping.internal.EntityCollectionPart;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.internal.ResultSetMappingResolutionContext;
import org.hibernate.query.results.FetchBuilder;
import org.hibernate.query.results.ResultBuilder;
import org.hibernate.query.results.ResultBuilderBasicValued;
import org.hibernate.query.results.internal.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.query.results.internal.dynamic.DynamicResultBuilderAttribute;
import org.hibernate.query.results.internal.dynamic.DynamicResultBuilderBasic;
import org.hibernate.query.results.internal.dynamic.DynamicResultBuilderBasicConverted;
import org.hibernate.query.results.internal.dynamic.DynamicResultBuilderBasicStandard;
import org.hibernate.query.results.internal.dynamic.DynamicResultBuilderEntityCalculated;
import org.hibernate.query.results.internal.dynamic.DynamicResultBuilderEntityStandard;
import org.hibernate.query.results.internal.dynamic.DynamicResultBuilderInstantiation;
import org.hibernate.query.results.internal.implicit.ImplicitFetchBuilder;
import org.hibernate.query.results.internal.implicit.ImplicitFetchBuilderBasic;
import org.hibernate.query.results.internal.implicit.ImplicitFetchBuilderDiscriminatedAssociation;
import org.hibernate.query.results.internal.implicit.ImplicitFetchBuilderEmbeddable;
import org.hibernate.query.results.internal.implicit.ImplicitFetchBuilderEntity;
import org.hibernate.query.results.internal.implicit.ImplicitFetchBuilderEntityPart;
import org.hibernate.query.results.internal.implicit.ImplicitFetchBuilderPlural;
import org.hibernate.query.results.internal.implicit.ImplicitModelPartResultBuilderEntity;
import org.hibernate.query.results.internal.implicit.ImplicitResultClassBuilder;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.embeddable.EmbeddableValuedFetchable;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaType;

public class Builders {
    public static DynamicResultBuilderBasic scalar(String columnAlias) {
        return Builders.scalar(columnAlias, columnAlias);
    }

    public static DynamicResultBuilderBasic scalar(String columnAlias, String resultAlias) {
        return new DynamicResultBuilderBasicStandard(columnAlias, resultAlias);
    }

    public static DynamicResultBuilderBasic scalar(String columnAlias, BasicType<?> type) {
        return Builders.scalar(columnAlias, columnAlias, type);
    }

    public static DynamicResultBuilderBasic scalar(String columnAlias, String resultAlias, BasicType<?> type) {
        return new DynamicResultBuilderBasicStandard(columnAlias, resultAlias, type);
    }

    public static DynamicResultBuilderBasic scalar(String columnAlias, Class<?> javaType, SessionFactoryImplementor factory) {
        return Builders.scalar(columnAlias, columnAlias, javaType, factory);
    }

    public static DynamicResultBuilderBasic scalar(String columnAlias, String resultAlias, Class<?> javaTypeClass, SessionFactoryImplementor factory) {
        JavaType javaType = factory.getTypeConfiguration().getJavaTypeRegistry().getDescriptor(javaTypeClass);
        return new DynamicResultBuilderBasicStandard(columnAlias, resultAlias, javaType);
    }

    public static <R> ResultBuilder converted(String columnAlias, Class<R> jdbcJavaType, AttributeConverter<?, R> converter, SessionFactoryImplementor sessionFactory) {
        return Builders.converted(columnAlias, null, jdbcJavaType, converter, sessionFactory);
    }

    public static <O, R> ResultBuilder converted(String columnAlias, Class<O> domainJavaType, Class<R> jdbcJavaType, AttributeConverter<O, R> converter, SessionFactoryImplementor sessionFactory) {
        return new DynamicResultBuilderBasicConverted<O, R>(columnAlias, domainJavaType, jdbcJavaType, converter, sessionFactory);
    }

    public static <R> ResultBuilder converted(String columnAlias, Class<R> jdbcJavaType, Class<? extends AttributeConverter<?, R>> converterJavaType, SessionFactoryImplementor sessionFactory) {
        return Builders.converted(columnAlias, null, jdbcJavaType, converterJavaType, sessionFactory);
    }

    public static <O, R> ResultBuilder converted(String columnAlias, Class<O> domainJavaType, Class<R> jdbcJavaType, Class<? extends AttributeConverter<O, R>> converterJavaType, SessionFactoryImplementor sessionFactory) {
        return new DynamicResultBuilderBasicConverted<O, R>(columnAlias, domainJavaType, jdbcJavaType, converterJavaType, sessionFactory);
    }

    public static ResultBuilderBasicValued scalar(int position) {
        return new DynamicResultBuilderBasicStandard(position);
    }

    public static ResultBuilderBasicValued scalar(int position, BasicType<?> type) {
        return new DynamicResultBuilderBasicStandard(position, type);
    }

    public static <J> DynamicResultBuilderInstantiation<J> instantiation(Class<J> targetJavaType, SessionFactoryImplementor factory) {
        JavaType targetJtd = factory.getTypeConfiguration().getJavaTypeRegistry().getDescriptor(targetJavaType);
        return new DynamicResultBuilderInstantiation(targetJtd);
    }

    public static ResultBuilder attributeResult(String columnAlias, String entityName, String attributePath, SessionFactoryImplementor sessionFactory) {
        String fullEntityName;
        if (attributePath.contains(".")) {
            throw new UnsupportedOperationException("Support for defining a NativeQuery attribute result based on a composite path is not yet implemented");
        }
        MappingMetamodelImplementor mappingMetamodel = sessionFactory.getMappingMetamodel();
        EntityPersister entityMapping = mappingMetamodel.findEntityDescriptor(fullEntityName = mappingMetamodel.getImportedName(entityName));
        if (entityMapping == null) {
            throw new IllegalArgumentException("Could not locate entity mapping : " + fullEntityName);
        }
        AttributeMapping attributeMapping = entityMapping.findAttributeMapping(attributePath);
        if (attributeMapping == null) {
            throw new IllegalArgumentException("Could not locate attribute mapping : " + fullEntityName + "." + attributePath);
        }
        if (attributeMapping instanceof SingularAttributeMapping) {
            SingularAttributeMapping singularAttributeMapping = (SingularAttributeMapping)attributeMapping;
            return new DynamicResultBuilderAttribute(singularAttributeMapping, columnAlias, fullEntityName, attributePath);
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Specified attribute mapping [%s.%s] not a basic attribute: %s", fullEntityName, attributePath, attributeMapping));
    }

    public static ResultBuilder attributeResult(String columnAlias, SingularAttribute<?, ?> attribute, SessionFactoryImplementor sessionFactory) {
        ManagedType managedType = attribute.getDeclaringType();
        if (!(managedType instanceof EntityType)) {
            throw new UnsupportedOperationException("Support for defining a NativeQuery attribute result based on a composite path is not yet implemented");
        }
        EntityType entityType = (EntityType)managedType;
        return Builders.attributeResult(columnAlias, entityType.getName(), attribute.getName(), sessionFactory);
    }

    public static DynamicResultBuilderEntityStandard entity(String tableAlias, String entityName, SessionFactoryImplementor sessionFactory) {
        EntityPersister entityMapping = sessionFactory.getMappingMetamodel().getEntityDescriptor(entityName);
        return new DynamicResultBuilderEntityStandard(entityMapping, tableAlias);
    }

    public static DynamicResultBuilderEntityCalculated entityCalculated(String tableAlias, String entityName, SessionFactoryImplementor sessionFactory) {
        return Builders.entityCalculated(tableAlias, entityName, null, sessionFactory);
    }

    public static DynamicResultBuilderEntityCalculated entityCalculated(String tableAlias, String entityName, LockMode explicitLockMode, SessionFactoryImplementor sessionFactory) {
        EntityPersister entityMapping = sessionFactory.getMappingMetamodel().getEntityDescriptor(entityName);
        return new DynamicResultBuilderEntityCalculated(entityMapping, tableAlias, explicitLockMode);
    }

    public static DynamicFetchBuilderLegacy fetch(String tableAlias, String ownerTableAlias, Fetchable fetchable) {
        return new DynamicFetchBuilderLegacy(tableAlias, ownerTableAlias, fetchable, new ArrayList<String>(), new HashMap<Fetchable, FetchBuilder>());
    }

    public static ResultBuilder resultClassBuilder(Class<?> resultMappingClass, ResultSetMappingResolutionContext resolutionContext) {
        return Builders.resultClassBuilder(resultMappingClass, resolutionContext.getMappingMetamodel());
    }

    public static ResultBuilder resultClassBuilder(Class<?> resultMappingClass, MappingMetamodel mappingMetamodel) {
        EntityPersister entityMappingType = mappingMetamodel.findEntityDescriptor(resultMappingClass);
        if (entityMappingType != null) {
            return new ImplicitModelPartResultBuilderEntity(entityMappingType);
        }
        return new ImplicitResultClassBuilder(resultMappingClass);
    }

    public static ImplicitFetchBuilder implicitFetchBuilder(NavigablePath fetchPath, Fetchable fetchable, DomainResultCreationState creationState) {
        BasicValuedModelPart basicValuedFetchable = fetchable.asBasicValuedModelPart();
        if (basicValuedFetchable != null) {
            return new ImplicitFetchBuilderBasic(fetchPath, basicValuedFetchable, creationState);
        }
        if (fetchable instanceof EmbeddableValuedFetchable) {
            EmbeddableValuedFetchable embeddableValuedFetchable = (EmbeddableValuedFetchable)fetchable;
            return new ImplicitFetchBuilderEmbeddable(fetchPath, embeddableValuedFetchable, creationState);
        }
        if (fetchable instanceof ToOneAttributeMapping) {
            ToOneAttributeMapping toOneAttributeMapping = (ToOneAttributeMapping)fetchable;
            return new ImplicitFetchBuilderEntity(fetchPath, toOneAttributeMapping, creationState);
        }
        if (fetchable instanceof PluralAttributeMapping) {
            PluralAttributeMapping pluralAttributeMapping = (PluralAttributeMapping)fetchable;
            return new ImplicitFetchBuilderPlural(fetchPath, pluralAttributeMapping, creationState);
        }
        if (fetchable instanceof EntityCollectionPart) {
            EntityCollectionPart entityCollectionPart = (EntityCollectionPart)fetchable;
            return new ImplicitFetchBuilderEntityPart(fetchPath, entityCollectionPart);
        }
        if (fetchable instanceof DiscriminatedAssociationAttributeMapping) {
            DiscriminatedAssociationAttributeMapping discriminatedAssociationAttributeMapping = (DiscriminatedAssociationAttributeMapping)fetchable;
            return new ImplicitFetchBuilderDiscriminatedAssociation(fetchPath, discriminatedAssociationAttributeMapping, creationState);
        }
        throw new UnsupportedOperationException();
    }
}

