/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import org.hibernate.community.dialect.DB2LegacySqlAstTranslator;
import org.hibernate.community.dialect.DB2iLegacyDialect;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class DB2iLegacySqlAstTranslator<T extends JdbcOperation>
extends DB2LegacySqlAstTranslator<T> {
    private final DatabaseVersion version;

    public DB2iLegacySqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement, DatabaseVersion version) {
        super(sessionFactory, statement);
        this.version = version;
    }

    @Override
    protected boolean shouldEmulateFetchClause(QueryPart queryPart) {
        if (this.getQueryPartForRowNumbering() == queryPart) {
            return false;
        }
        if (this.useOffsetFetchClause(queryPart) && !this.isRowsOnlyFetchClauseType(queryPart)) {
            return true;
        }
        return this.version.isBefore(7, 10) && queryPart.getFetchClauseExpression() != null && !(queryPart.getFetchClauseExpression() instanceof Literal);
    }

    @Override
    protected boolean supportsOffsetClause() {
        return this.version.isSameOrAfter(7, 10);
    }

    @Override
    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        this.renderComparisonStandard(lhs, operator, rhs);
    }

    @Override
    public DatabaseVersion getDB2Version() {
        return DB2iLegacyDialect.DB2_LUW_VERSION9;
    }
}

