/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.tomcat.autoconfigure.actuate.web.server;

import java.util.Collection;
import java.util.function.Function;
import org.apache.catalina.Valve;
import org.apache.catalina.valves.AccessLogValve;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.actuate.autoconfigure.web.server.AccessLogCustomizer;
import org.springframework.boot.tomcat.ConfigurableTomcatWebServerFactory;
import org.springframework.boot.tomcat.autoconfigure.actuate.web.server.TomcatManagementServerProperties;

class TomcatAccessLogCustomizer<T extends ConfigurableTomcatWebServerFactory>
extends AccessLogCustomizer<T> {
    private final Function<T, Collection<Valve>> engineValvesExtractor;

    TomcatAccessLogCustomizer(TomcatManagementServerProperties properties, Function<T, Collection<Valve>> engineValvesExtractor) {
        super(properties.getAccesslog().getPrefix());
        this.engineValvesExtractor = engineValvesExtractor;
    }

    public void customize(T factory) {
        AccessLogValve accessLogValve = this.findAccessLogValve(factory);
        if (accessLogValve == null) {
            return;
        }
        accessLogValve.setPrefix(this.customizePrefix(accessLogValve.getPrefix()));
    }

    private @Nullable AccessLogValve findAccessLogValve(T factory) {
        for (Valve engineValve : this.engineValvesExtractor.apply(factory)) {
            if (!(engineValve instanceof AccessLogValve)) continue;
            AccessLogValve accessLogValve = (AccessLogValve)engineValve;
            return accessLogValve;
        }
        return null;
    }
}

