/*
 * Decompiled with CFR 0.152.
 */
package com.github.therapi.runtimejavadoc;

import com.github.therapi.runtimejavadoc.CommentVisitor;
import com.github.therapi.runtimejavadoc.Link;
import com.github.therapi.runtimejavadoc.Value;

public class ToHtmlStringCommentVisitor
implements CommentVisitor {
    protected StringBuilder buf = new StringBuilder();

    @Override
    public void commentText(String value) {
        this.buf.append(value);
    }

    @Override
    public void inlineLink(Link link) {
        this.buf.append("{@link ");
        this.buf.append(link);
        this.buf.append("}");
    }

    @Override
    public void inlineTag(String name, String value) {
        if ("code".equals(name)) {
            this.buf.append("<code>");
            this.buf.append(ToHtmlStringCommentVisitor.escapeHtml(value));
            this.buf.append("</code>");
        } else if ("literal".equals(name)) {
            this.buf.append(ToHtmlStringCommentVisitor.escapeHtml(value));
        } else {
            this.buf.append("{@");
            this.buf.append(name);
            this.buf.append(" ");
            this.buf.append(value);
            this.buf.append("}");
        }
    }

    @Override
    public void inlineValue(Value value) {
        if (value.getReferencedMemberName() == null) {
            this.buf.append("{@value}");
        } else {
            this.buf.append("{@value ");
            this.buf.append(value);
            this.buf.append("}");
        }
    }

    public String build() {
        return this.buf.toString();
    }

    protected static String escapeHtml(String value) {
        StringBuilder escaped = new StringBuilder();
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c == '\"') {
                escaped.append("&quot;");
                continue;
            }
            if (c == '&') {
                escaped.append("&amp;");
                continue;
            }
            if (c == '<') {
                escaped.append("&lt;");
                continue;
            }
            if (c == '>') {
                escaped.append("&gt;");
                continue;
            }
            escaped.append(c);
        }
        return escaped.toString();
    }
}

