/*
 * Decompiled with CFR 0.152.
 */
package com.github.therapi.runtimejavadoc.internal.parser;

import com.github.therapi.runtimejavadoc.ClassJavadoc;
import com.github.therapi.runtimejavadoc.Comment;
import com.github.therapi.runtimejavadoc.FieldJavadoc;
import com.github.therapi.runtimejavadoc.MethodJavadoc;
import com.github.therapi.runtimejavadoc.OtherJavadoc;
import com.github.therapi.runtimejavadoc.ParamJavadoc;
import com.github.therapi.runtimejavadoc.SeeAlsoJavadoc;
import com.github.therapi.runtimejavadoc.ThrowsJavadoc;
import com.github.therapi.runtimejavadoc.internal.parser.BlockTag;
import com.github.therapi.runtimejavadoc.internal.parser.CommentParser;
import com.github.therapi.runtimejavadoc.internal.parser.ParsedJavadoc;
import com.github.therapi.runtimejavadoc.internal.parser.SeeAlsoParser;
import com.github.therapi.runtimejavadoc.internal.parser.ThrowsTagParser;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class JavadocParser {
    private static final Pattern blockSeparator = Pattern.compile("^\\s*@(?=\\S)", 8);
    private static final Pattern whitespace = Pattern.compile("\\s");

    private static ParamJavadoc parseParam(BlockTag t, String owningClass) {
        String[] paramNameAndComment = whitespace.split(t.value, 2);
        String paramName = paramNameAndComment[0];
        String paramComment = paramNameAndComment.length == 1 ? "" : paramNameAndComment[1];
        return new ParamJavadoc(paramName, CommentParser.parse(owningClass, paramComment));
    }

    public static ClassJavadoc parseClassJavadoc(String className, String javadoc, List<FieldJavadoc> fields, List<FieldJavadoc> enumConstants, List<MethodJavadoc> methods, List<MethodJavadoc> constructors) {
        ParsedJavadoc parsed = JavadocParser.parse(javadoc, className);
        return new ClassJavadoc(className, parsed.getDescription(), fields, enumConstants, methods, constructors, parsed.getOtherDocs(), parsed.getSeeAlsoDocs(), parsed.getParamDocs());
    }

    public static FieldJavadoc parseFieldJavadoc(String owningClass, String fieldName, String javadoc) {
        ParsedJavadoc parsed = JavadocParser.parse(javadoc, owningClass);
        return new FieldJavadoc(fieldName, parsed.getDescription(), parsed.getOtherDocs(), parsed.getSeeAlsoDocs());
    }

    public static MethodJavadoc parseMethodJavadoc(String owningClass, String methodName, List<String> paramTypes, String javadoc) {
        ParsedJavadoc parsed = JavadocParser.parse(javadoc, owningClass);
        return new MethodJavadoc(methodName, paramTypes, parsed.getDescription(), parsed.getParamDocs(), parsed.getThrowsDocs(), parsed.getOtherDocs(), parsed.getReturns(), parsed.getSeeAlsoDocs());
    }

    private static ParsedJavadoc parse(String javadoc, String owningClass) {
        String[] blocks = blockSeparator.split(javadoc);
        ArrayList<ParamJavadoc> paramDocs = new ArrayList<ParamJavadoc>();
        ArrayList<SeeAlsoJavadoc> seeAlsoDocs = new ArrayList<SeeAlsoJavadoc>();
        ArrayList<ThrowsJavadoc> throwsDocs = new ArrayList<ThrowsJavadoc>();
        ArrayList<OtherJavadoc> otherDocs = new ArrayList<OtherJavadoc>();
        Comment returns = null;
        block13: for (int i = 1; i < blocks.length; ++i) {
            BlockTag blockTag = JavadocParser.parseBlockTag(blocks[i]);
            switch (blockTag.name) {
                case "param": {
                    paramDocs.add(JavadocParser.parseParam(blockTag, owningClass));
                    continue block13;
                }
                case "return": {
                    returns = CommentParser.parse(owningClass, blockTag.value);
                    continue block13;
                }
                case "see": {
                    SeeAlsoJavadoc seeAlso = SeeAlsoParser.parseSeeAlso(owningClass, blockTag.value);
                    if (seeAlso == null) continue block13;
                    seeAlsoDocs.add(seeAlso);
                    continue block13;
                }
                case "throws": 
                case "exception": {
                    ThrowsJavadoc throwsDoc = ThrowsTagParser.parseTag(owningClass, blockTag.value);
                    if (throwsDoc == null) continue block13;
                    throwsDocs.add(throwsDoc);
                    continue block13;
                }
                default: {
                    otherDocs.add(new OtherJavadoc(blockTag.name, CommentParser.parse(owningClass, blockTag.value)));
                }
            }
        }
        Comment description = CommentParser.parse(owningClass, blocks[0].trim());
        return new ParsedJavadoc(description, otherDocs, seeAlsoDocs, paramDocs, throwsDocs, returns);
    }

    private static BlockTag parseBlockTag(String block) {
        String[] s = whitespace.split(block.trim(), 2);
        String name = s[0];
        String value = s.length > 1 ? s[1] : "";
        return new BlockTag(name, value);
    }
}

